if (typeof Promise !== "undefined" && !Promise.prototype.finally) {
  Promise.prototype.finally = function(callback) {
    const promise = this.constructor;
    return this.then(
      (value) => promise.resolve(callback()).then(() => value),
      (reason) => promise.resolve(callback()).then(() => {
        throw reason;
      })
    );
  };
}
;
if (typeof uni !== "undefined" && uni && uni.requireGlobal) {
  const global = uni.requireGlobal();
  ArrayBuffer = global.ArrayBuffer;
  Int8Array = global.Int8Array;
  Uint8Array = global.Uint8Array;
  Uint8ClampedArray = global.Uint8ClampedArray;
  Int16Array = global.Int16Array;
  Uint16Array = global.Uint16Array;
  Int32Array = global.Int32Array;
  Uint32Array = global.Uint32Array;
  Float32Array = global.Float32Array;
  Float64Array = global.Float64Array;
  BigInt64Array = global.BigInt64Array;
  BigUint64Array = global.BigUint64Array;
}
;
if (uni.restoreGlobal) {
  uni.restoreGlobal(Vue, weex, plus, setTimeout, clearTimeout, setInterval, clearInterval);
}
(function(vue) {
  "use strict";
  function formatAppLog(type2, filename, ...args) {
    if (uni.__log__) {
      uni.__log__(type2, filename, ...args);
    } else {
      console[type2].apply(console, [...args, filename]);
    }
  }
  const default_host = "https://api.newayz.com";
  const default_api = "/location/hub/v1/track_points";
  const poi_search_api = "/location/scenario/v1/placesearch";
  const nearby_search_api = "/location/scenario/v1/nearbysearch";
  const geocode_api = "/location/scenario/v1/geocode";
  const IPBaseUrl = "https://api.newayz.com/positioning/ip/v1/ips";
  let defaultOption = {
    interval: 5e3,
    // 定位间隔
    isLocateOnce: true,
    // 是否单次定位
    deviceId: "",
    // 设备ID
    trakUrl: ""
    // 请求URL
  };
  const { registerUTSInterface, initUTSProxyClass, initUTSProxyFunction, initUTSPackageName, initUTSIndexClassName, initUTSClassName } = uni;
  const name = "uniWifi";
  const moduleName = "uni-wifi";
  const moduleType = "";
  const errMsg = ``;
  const is_uni_modules = true;
  const pkg = /* @__PURE__ */ initUTSPackageName(name, is_uni_modules);
  const cls = /* @__PURE__ */ initUTSIndexClassName(name, is_uni_modules);
  const startWifi = /* @__PURE__ */ initUTSProxyFunction(false, { moduleName, moduleType, errMsg, main: true, package: pkg, class: cls, name: "startWifiByJs", keepAlive: false, params: [{ "name": "option", "type": "UTSSDKModulesUniWifiWifiOptionJSONObject" }], return: "" });
  const stopWifi = /* @__PURE__ */ initUTSProxyFunction(false, { moduleName, moduleType, errMsg, main: true, package: pkg, class: cls, name: "stopWifiByJs", keepAlive: false, params: [{ "name": "option", "type": "UTSSDKModulesUniWifiWifiOptionJSONObject" }], return: "" });
  const getWifiList = /* @__PURE__ */ initUTSProxyFunction(false, { moduleName, moduleType, errMsg, main: true, package: pkg, class: cls, name: "getWifiListByJs", keepAlive: false, params: [{ "name": "option", "type": "UTSSDKModulesUniWifiWifiOptionJSONObject" }], return: "" });
  const onGetWifiList = /* @__PURE__ */ initUTSProxyFunction(false, { moduleName, moduleType, errMsg, main: true, package: pkg, class: cls, name: "onGetWifiListByJs", keepAlive: false, params: [{ "name": "callback", "type": "UTSCallback" }], return: "" });
  const offGetWifiList = /* @__PURE__ */ initUTSProxyFunction(false, { moduleName, moduleType, errMsg, main: true, package: pkg, class: cls, name: "offGetWifiListByJs", keepAlive: false, params: [{ "name": "callback", "type": "UTSCallback" }], return: "" });
  let scanWifiList = [];
  let type = "start";
  const _WifiChange = (res) => {
    formatAppLog("log", "at utils/wz_wifi.js:5", "wifi数据变化", res.wifiList.length);
    scanWifiList = formatWifi(res.wifiList);
  };
  const wifiCallback = (resolve, reject) => {
    return {
      success: (res) => {
        formatAppLog("log", "at utils/wz_wifi.js:12", "操作wifi成功", type === "start");
        if (type === "start") {
          onGetWifiList(_WifiChange);
        }
        resolve(res);
      },
      fail: (err) => {
        formatAppLog("error", "at utils/wz_wifi.js:19", "操作wifi失败", err);
        reject(new Error(err));
      }
    };
  };
  function stopScanWifi() {
    offGetWifiList(_WifiChange);
  }
  function stoWifi() {
    type = "stop";
    return new Promise((resolve, reject) => {
      stopWifi(wifiCallback(resolve, reject));
    });
  }
  const firstStartWifi = () => {
    return new Promise((resolve, reject) => {
      type = "start";
      startWifi(wifiCallback(resolve, reject));
    });
  };
  const scanWifi = () => {
    return new Promise((resolve, reject) => {
      getWifiList({
        success: (res) => {
          formatAppLog("log", "at utils/wz_wifi.js:61", "扫描 WIFI 成功", res);
          onGetWifiList(_WifiChange);
          resolve(res);
        },
        fail: (err) => {
          formatAppLog("log", "at utils/wz_wifi.js:66", "扫描 WIFI 失败", err);
          reject(err);
        }
      });
    });
  };
  const formatWifi = (list) => {
    formatAppLog("log", "at utils/wz_wifi.js:75", "list 类型 formatWifi：");
    formatAppLog("log", "at utils/wz_wifi.js:76", "list 类型：", Object.prototype.toString.call(list));
    if (!Array.isArray(list)) {
      formatAppLog("error", "at utils/wz_wifi.js:78", "错误：formatWifi 接收的 list 不是数组！");
      return;
    }
    formatAppLog("log", "at utils/wz_wifi.js:81", "===============================");
    const res = list.map((item) => {
      const {
        signalStrength
      } = item;
      item.signalStrength = parseInt(100 - signalStrength / 2);
      item.macAddress = item.BSSID;
      item.ssid = item.SSID;
      item.frequency = item.frequency;
      return item;
    });
    return res;
  };
  const wifiManager = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    firstStartWifi,
    scanWifi,
    get scanWifiList() {
      return scanWifiList;
    },
    stoWifi,
    stopScanWifi
  }, Symbol.toStringTag, { value: "Module" }));
  let locationTrack = {
    asset: {
      id: ""
    },
    location: {
      gnss: {},
      wifis: [],
      bluetooths: [],
      position: {}
    },
    product: {
      name: "uni_program",
      version: "v1.0.0"
    },
    id: generateUUID
  };
  let lngLatTrack = {
    asset: {
      id: ""
    },
    location: {
      timestamp: 0,
      position: {
        point: {}
      }
    },
    id: generateUUID
  };
  function generateUUID() {
    let d = 0;
    (/* @__PURE__ */ new Date()).getTime();
    if (window.performance && typeof window.performance.now === "function") {
      d += performance.now();
    }
    var uuid = "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(
      /[xy]/g,
      function(c) {
        var r = (d + Math.random() * 16) % 16 | 0;
        d = Math.floor(d / 16);
        return (c == "x" ? r : r & 3 | 8).toString(16);
      }
    );
    return uuid;
  }
  let ak = "";
  let wz_option = {};
  let isAndroid = false;
  let timerLocation = null;
  let isToUni = false;
  let isNeedScan = false;
  let uniLocation = {
    timestamp: 0,
    longitude: 0,
    latitude: 0,
    speed: 0,
    accuracy: 0,
    source: "",
    address: ""
  };
  let wzLocation = {
    source: "",
    timestamp: 0,
    longitude: 0,
    latitude: 0,
    accuracy: 0,
    spatialReference: "",
    address: "",
    place: {}
  };
  let mGnss = {
    timestamp: 0,
    point: {
      longitude: 0,
      latitude: 0
    },
    accuracy: 0
  };
  let scanIntervalId;
  let isScanning = true;
  function initOption(accessKey, deViceId, isLocateOnce, interval) {
    ak = accessKey;
    wz_option = defaultOption;
    wz_option.deviceId = deViceId;
    wz_option.isLocateOnce = isLocateOnce;
    if (interval > wz_option.interval) {
      wz_option.interval = interval;
    }
  }
  function getLocation(success, error2) {
    try {
      const sysInfo = uni.getSystemInfoSync();
      const platOS = sysInfo.osName;
      isAndroid = platOS === "android";
      const osVersion = sysInfo.osVersion;
      const deviceType = sysInfo.deviceType;
      const uniPlatForm = sysInfo.uniPlatform;
      if (uniPlatForm === "app" || uniPlatForm === "mp-weixin") {
        if (isEnableLocation(error2)) {
          const requestUrl = default_host + default_api + "?access_key=" + ak;
          formatAppLog("log", "at utils/wz_location.js:71", "getLocation：", isAndroid, requestUrl);
          if (isAndroid) {
            locationTrack.asset.id = wz_option.deviceId;
            firstStartWifi().then(
              (res) => {
                isNeedScan = true;
                formatAppLog("log", "at utils/wz_location.js:77", "getLocation：", "准备请求--->");
                getLocationFromServer(success, error2);
              },
              (erro) => {
                getLocationFromUniapp(success, error2);
              }
            );
          } else {
            getLocationFromUniapp(success, error2);
          }
        }
      } else {
        formatAppLog("log", "at utils/wz_location.js:89", "uniPlatForm：", uniPlatForm);
        isNeedScan = false;
        getLocationFromUniapp(success, error2);
      }
    } catch (erroInfo) {
      error2({
        code: 2001,
        msg: erroInfo
      });
    }
  }
  function isEnableLocation(error2) {
    const systemSetting = uni.getSystemSetting();
    formatAppLog("log", "at utils/wz_location.js:103", "systemSetting：", systemSetting);
    const lEnable = systemSetting && typeof systemSetting.locationEnabled !== "undefined" ? systemSetting.locationEnabled : true;
    systemSetting && typeof systemSetting.wifiEnabled !== "undefined" ? systemSetting.wifiEnabled : false;
    if (!lEnable) {
      error2({
        code: 1001,
        msg: "定位权限未开"
      });
      return false;
    }
    if (!ak) {
      error2({
        code: 1003,
        msg: "您尚未配置 appKey"
      });
      return false;
    }
    if (!wz_option) {
      error2({
        code: 1004,
        msg: "option 参数未配置"
      });
      return false;
    }
    if (!wz_option.deviceId) {
      error2({
        code: 1005,
        msg: "option 参数非法, 需提供设备 ID "
      });
      return false;
    }
    return true;
  }
  function poiSearch(searchkey, city, page_index = 1, page_size = 20) {
    return new Promise((resolve, reject) => {
      if (!ak) {
        reject({
          code: 1003,
          msg: "您尚未配置 appKey"
        });
        return;
      }
      const requestUrl = default_host + poi_search_api + "?access_key=" + ak + "&name=" + searchkey + "&city=" + city + "&page_index=" + page_index + "&page_size=" + page_size;
      getRequest(requestUrl, resolve, reject);
    });
  }
  function poiNearbySearch(keyword, category, location, radius = 5e3, orderby = "distance_score", page_index = 1, page_size = 20) {
    return new Promise((resolve, reject) => {
      if (!ak) {
        reject({
          code: 1003,
          msg: "您尚未配置 appKey"
        });
        return;
      }
      if (!location) {
        return reject({
          code: 1008,
          msg: "请先获取定位"
        });
      }
      if (!keyword) {
        return reject({
          code: 1009,
          msg: "请填写搜索关键词"
        });
      }
      const requestUrl = default_host + nearby_search_api + "?access_key=" + ak + "&keywords=" + keyword + "&category=" + category + "&location=" + location + "&radius=" + radius + "&orderby=" + orderby + "&page_index=" + page_index + "&page_size=" + page_size;
      getRequest(requestUrl, resolve, reject);
    });
  }
  function getGeoCode(address, city) {
    return new Promise((resolve, reject) => {
      if (!ak) {
        reject({
          code: 1003,
          msg: "您尚未配置 appKey"
        });
        return;
      }
      const requestUrl = default_host + geocode_api + "?access_key=" + ak + "&address=" + address + "&city=" + city;
      getRequest(requestUrl, resolve, reject);
    });
  }
  function getReverseCode(longitude, latitude, spatialReference) {
    return new Promise((resolve, reject) => {
      if (!ak) {
        reject({
          code: 1003,
          msg: "您尚未配置 appKey"
        });
        return;
      }
      const requestUrl = default_host + default_api + "?access_key=" + ak;
      uniLocation = {
        latitude,
        longitude,
        source: "",
        speed: 0,
        accuracy: 30,
        altitude: 0,
        spatialReference,
        timestamp: (/* @__PURE__ */ new Date()).getTime()
      };
      formatUniLocation();
      requestReverseBody(requestUrl, lngLatTrack, resolve, reject);
    });
  }
  function getLocationFromServer(success, error2) {
    if (wz_option.isLocateOnce) {
      startInterval();
      setTimeout(function() {
        return stopInterval(success, error2);
      }, 5e3);
      reqByWifi(success, error2);
    } else {
      startSysGpsLocation();
      reqByWifi(success, error2);
      timerLocation = setInterval(() => {
        reqByWifi(success, error2);
      }, wz_option.interval);
    }
  }
  function getLocationFromUniapp(success, error2) {
    const requestUrl = default_host + default_api + "?access_key=" + ak;
    isToUni = true;
    if (wz_option.isLocateOnce) {
      uni.getLocation({
        type: "wgs84",
        isHighAccuracy: true,
        success: (res) => {
          formatAppLog("log", "at utils/wz_location.js:265", "当前位置的经度：" + res.longitude);
          formatAppLog("log", "at utils/wz_location.js:266", "当前位置的纬度：" + res.latitude);
          uniLocation = {
            latitude: res.latitude,
            longitude: res.longitude,
            source: "",
            speed: res.speed,
            accuracy: res.accuracy,
            altitude: res.altitude,
            spatialReference: "wgs84",
            timestamp: (/* @__PURE__ */ new Date()).getTime()
          };
          formatUniLocation();
          requestBody(requestUrl, lngLatTrack, success, error2);
        },
        fail: (err) => {
          formatAppLog("log", "at utils/wz_location.js:282", "err：" + JSON.stringify(err));
          getIPLocation(success, error2);
        },
        complete: (res) => {
        }
      });
    } else {
      uni.startLocationUpdate({
        type: "wgs84",
        success: (res) => {
          uni.onLocationChange((res2) => {
            const { latitude, longitude, speed, accuracy, altitude } = res2;
            if (!latitude || !longitude || latitude === 0 || longitude === 0) {
              error2({
                code: 10015,
                msg: "【定位异常】经纬度为空或无效值"
              });
              return;
            }
            uniLocation = {
              latitude: res2.latitude,
              longitude: res2.longitude,
              source: "",
              speed: res2.speed,
              accuracy: res2.accuracy,
              altitude: res2.altitude,
              spatialReference: "wgs84",
              timestamp: (/* @__PURE__ */ new Date()).getTime()
            };
            formatUniLocation();
            requestBody(requestUrl, lngLatTrack, success, error2);
          });
        },
        fail: (err) => {
          error2({
            code: 10011,
            msg: err.errMsg
          });
        },
        complete: (msg) => {
        }
      });
    }
  }
  function startSysGpsLocation() {
    isToUni = true;
    uni.startLocationUpdate({
      type: "wgs84",
      success: (res) => {
        uni.onLocationChange((res2) => {
          mGnss = {
            timestamp: (/* @__PURE__ */ new Date()).getTime(),
            point: {
              longitude: res2.longitude,
              latitude: res2.latitude
            },
            accuracy: res2.accuracy
          };
        });
      },
      fail: (err) => {
        error({
          code: 10011,
          msg: err.errMsg
        });
      },
      complete: (msg) => {
      }
    });
  }
  function getIPLocation(resolve, reject) {
    const ipUrl = IPBaseUrl + "?access_key=" + ak;
    formatAppLog("log", "at utils/wz_location.js:366", "getIPLocation");
    uni.request({
      url: ipUrl,
      method: "GET",
      success: (res) => {
        formatAppLog("log", "at utils/wz_location.js:371", "request success ： ", res);
        const resData = res.data || {};
        if (res.statusCode === 200 && resData && resData.location) {
          const location = resData.location;
          if (location.address && location.address.name) {
            wzLocation = formatIPLocation(resData);
            resolve(wzLocation);
            return;
          }
        }
        const errMsg2 = res.statusCode === 200 ? "定位服务返回成功，但地址数据不完整" : `定位服务返回失败，状态码：${res.statusCode}`;
        const errObj = { code: res.statusCode || 10011, msg: errMsg2 };
        reject(errObj);
      },
      fail: (error2) => {
        formatAppLog("error", "at utils/wz_location.js:391", "IP定位请求接口失败：", error2);
        const errObj = {
          code: 10011,
          msg: "定位返回失败：" + (error2.errMsg || JSON.stringify(error2))
        };
        reject(errObj);
      },
      // 兜底：无论成功失败，防止请求卡死（可选但建议加）
      complete: () => {
        formatAppLog("log", "at utils/wz_location.js:400", "定位请求完成");
      }
    });
  }
  function reqByWifi(success, error2) {
    const requestUrl = default_host + default_api + "?access_key=" + ak;
    formatAppLog("log", "at utils/wz_location.js:409", "开始扫描 WIFI ： ");
    isScanning = true;
    scanWifi().then(
      (res) => {
        formatAppLog("log", "at utils/wz_location.js:413", "扫描 WIFI成功回调 ： ");
        if (scanIntervalId) {
          clearInterval(scanIntervalId);
        }
        isScanning = false;
        const wifiList = scanWifiList;
        if (wifiList.length === 0 && wz_option.isLocateOnce) {
          getLocationFromUniapp(success, error2);
        } else {
          locationTrack.location.wifis = wifiList;
          locationTrack.location.gnss = mGnss;
          requestBody(requestUrl, locationTrack, success, error2);
        }
      },
      (fail) => {
        isScanning = false;
        stopScanWifi();
        getLocationFromUniapp(success, error2);
      }
    );
  }
  function startInterval() {
    formatAppLog("log", "at utils/wz_location.js:440", "startInterval ： ");
    scanIntervalId = setInterval(() => {
      formatAppLog("log", "at utils/wz_location.js:442", "This runs every 1 second");
    }, 1e3);
  }
  function stopInterval(success, error2) {
    clearInterval(scanIntervalId);
    const wifiList = scanWifiList;
    formatAppLog("log", "at utils/wz_location.js:452", "stopInterval isScanning ", isScanning);
    if (isScanning) {
      const requestUrl = default_host + default_api + "?access_key=" + ak;
      if (wifiList && wifiList.length >= 0) {
        locationTrack.location.wifis = wifiList;
        locationTrack.location.gnss = mGnss;
        requestBody(requestUrl, locationTrack, success, error2);
      } else {
        error2({
          code: 10010,
          msg: "定位服务返回失败"
        });
      }
      stopScanWifi();
    }
  }
  function requestBody(reqUrl, data, callBack, fail) {
    formatAppLog("log", "at utils/wz_location.js:480", "requestBody ： ", data);
    uni.request({
      url: reqUrl,
      method: "POST",
      data,
      success: (res) => {
        formatAppLog("log", "at utils/wz_location.js:486", "request success ： " + JSON.stringify(res));
        const resData = res.data;
        if (res.statusCode == 200 && resData != null && resData.location != null && resData.location.address != null) {
          wzLocation = formatLocation(resData);
          if (wz_option.isLocateOnce) {
            stopLocation();
          }
          callBack(wzLocation);
        } else {
          fail({
            code: res.statusCode,
            msg: "定位服务返回失败"
          });
        }
      },
      fail: (error2) => {
        formatAppLog("log", "at utils/wz_location.js:507", error2);
        fail({
          code: 10010,
          msg: "定位返回失败：" + error2
        });
      }
    });
  }
  function requestReverseBody(reqUrl, data, callBack, fail) {
    formatAppLog("log", "at utils/wz_location.js:525", "requestReverseBody ： ", data);
    uni.request({
      url: reqUrl,
      method: "POST",
      data,
      success: (res) => {
        formatAppLog("log", "at utils/wz_location.js:531", "request success ： " + JSON.stringify(res));
        const resData = res.data;
        if (res.statusCode == 200 && resData != null && resData.location != null && resData.location.address != null) {
          wzLocation = formatLocation(resData);
          callBack(wzLocation);
        } else {
          fail({
            code: res.statusCode,
            msg: "定位服务返回失败"
          });
        }
      },
      fail: (error2) => {
        formatAppLog("log", "at utils/wz_location.js:549", error2);
        fail({
          code: 10010,
          msg: "定位返回失败：" + error2
        });
      }
    });
  }
  function getRequest(reqUrl, callBack, fail) {
    formatAppLog("log", "at utils/wz_location.js:566", "request:", reqUrl);
    uni.request({
      url: reqUrl,
      method: "GET",
      success: (res) => {
        const resData = res.data;
        if (res.statusCode == 200 && resData != null) {
          callBack(resData);
          return;
        }
        fail({ code: res.statusCode, msg: "请求异常" });
      },
      fail: (error2) => {
        formatAppLog("log", "at utils/wz_location.js:579", error2);
        fail({
          code: 10010,
          msg: "定位返回失败：" + error2
        });
      }
    });
  }
  function stopLocation() {
    formatAppLog("log", "at utils/wz_location.js:589", "stopLocation");
    if (isToUni && !wz_option.isLocateOnce) {
      isToUni = false;
      uni.stopLocationUpdate();
      uni.offLocationChange(function(res) {
      });
    }
    if (wifiManager != null && isNeedScan) {
      stoWifi();
    }
    if (timerLocation) {
      clearInterval(timerLocation);
      timerLocation = null;
    }
  }
  function setAk(accessKey) {
    ak = accessKey;
  }
  const formatLocation = (res) => {
    const {
      address,
      place,
      position: {
        source,
        accuracy,
        spatialReference,
        timestamp,
        point: {
          longitude,
          latitude
        }
      }
    } = res.location;
    return {
      source,
      timestamp,
      longitude,
      latitude,
      accuracy,
      spatialReference,
      address,
      place
    };
  };
  const formatIPLocation = (res) => {
    const {
      location: {
        address,
        place = "",
        // 原数据无此字段，兜底空字符串
        position: {
          source = "",
          // 原数据无此字段，兜底空字符串
          accuracy = 0,
          // 原数据无此字段，兜底数字0
          spatialReference = "",
          // 原数据无此字段，兜底空字符串
          timestamp = (/* @__PURE__ */ new Date()).getTime(),
          // 原数据无此字段，兜底空字符串
          point: {
            longitude,
            latitude
          }
        }
      }
    } = res;
    return {
      source,
      timestamp,
      longitude,
      latitude,
      accuracy,
      spatialReference,
      address,
      place
    };
  };
  function formatUniLocation() {
    const {
      source,
      timestamp,
      longitude,
      latitude,
      accuracy,
      spatialReference
    } = uniLocation;
    lngLatTrack.location.position = {
      point: {
        longitude,
        latitude
      },
      source,
      timestamp,
      accuracy,
      spatialReference
    };
  }
  const _export_sfc = (sfc, props) => {
    const target = sfc.__vccOpts || sfc;
    for (const [key, val] of props) {
      target[key] = val;
    }
    return target;
  };
  const _sfc_main$2 = {
    data() {
      return {
        webViewSrc: "static/map/map_view.html",
        webViewReady: false,
        // 标记web-view原生实例是否就绪
        title: "Hello",
        wzLocation: {
          accuracy: 0,
          address: {
            name: "初始地址"
            // 加初始值，方便测试显示
          },
          place: {
            name: "初始位置"
            // 加初始值，方便测试显示
          },
          latitude: 27.945061,
          // 加初始值
          longitude: 107.191693,
          // 加初始值
          source: "",
          spatialReference: "",
          timestamp: (/* @__PURE__ */ new Date()).toLocaleString()
          // 加初始值
        }
      };
    },
    onLoad() {
    },
    // 新增：页面渲染完成兜底初始化
    onReady() {
      formatAppLog("log", "at pages/index/index.vue:37", "页面onReady，兜底初始化web-view就绪状态");
      setTimeout(() => {
        if (!this.webViewReady) {
          this.webViewReady = true;
          formatAppLog("log", "at pages/index/index.vue:43", "@load未触发，已兜底标记web-view就绪");
        }
      }, 1e3);
    },
    methods: {
      // web-view加载完成回调：延迟标记就绪，等待原生实例初始化
      webViewLoad() {
        formatAppLog("log", "at pages/index/index.vue:50", "web-view DOM加载完成，等待原生实例初始化");
        const delay = 0;
        setTimeout(() => {
          this.webViewReady = true;
          this.sendLocationData();
          formatAppLog("log", "at pages/index/index.vue:56", "web-view 原生实例就绪，标记完成");
        }, delay);
      },
      // 向 web-view 发送定位数据（全端兼容修复版）
      sendLocationData() {
        if (!this.webViewReady) {
          formatAppLog("warn", "at pages/index/index.vue:62", "web-view 尚未就绪，跳过数据发送");
          return;
        }
        const locationData = JSON.parse(JSON.stringify(this.wzLocation));
        const dataStr = JSON.stringify(locationData);
        let webView = null;
        try {
          const webViewVueRef = this.$refs.webViewRef;
          webView = webViewVueRef.$el || webViewVueRef._nativeInstance || webViewVueRef;
          formatAppLog("log", "at pages/index/index.vue:76", "【App端】webView.evalJS是否存在：", typeof (webView == null ? void 0 : webView.evalJS) === "function");
          if (!webView || typeof webView.evalJS !== "function") {
            const pages = getCurrentPages();
            const currentPage = pages[pages.length - 1];
            if (currentPage && currentPage.$getAppWebview) {
              const pageWebview = currentPage.$getAppWebview();
              const allSubWebview = pageWebview.children();
              for (let i = 0; i < allSubWebview.length; i++) {
                const subWeb = allSubWebview[i];
                if (subWeb.getURL && subWeb.getURL().includes("map_view.html")) {
                  webView = subWeb;
                  break;
                }
              }
            }
          }
          formatAppLog("log", "at pages/index/index.vue:96", "【App端】Vue组件壳：", webViewVueRef);
          formatAppLog("log", "at pages/index/index.vue:97", "【App端】原生web-view实例：", webView);
          formatAppLog("log", "at pages/index/index.vue:98", "【App端】webView.evalJS是否存在：", typeof (webView == null ? void 0 : webView.evalJS) === "function");
          if (webView && typeof webView.evalJS === "function") {
            const jsCode = `window.dispatchEvent(new CustomEvent('uniMessage',{detail:{wzLocation:${dataStr}}}))`;
            webView.evalJS(jsCode);
            formatAppLog("log", "at pages/index/index.vue:104", "【App端】evalJS执行成功，定位数据已发送");
          } else {
            formatAppLog("error", "at pages/index/index.vue:106", "【App端】未获取到带evalJS的原生web-view实例");
            setTimeout(() => this.sendLocationData(), 1e3);
          }
        } catch (e) {
          formatAppLog("error", "at pages/index/index.vue:111", "【App端】sendLocationData异常：", e);
        }
      },
      // 接收 web-view 按钮点击消息
      handleWebMessage(e) {
        formatAppLog("log", "at pages/index/index.vue:148", "收到 web-view 消息：", e.detail.data);
        const message = e.detail.data[e.detail.data.length - 1];
        if (!message || !message.type)
          return;
        switch (message.type) {
          case "singleClick":
            this.singleClick();
            break;
          case "conitueClick":
            this.conitueClick();
            break;
          case "stopLocation":
            this.stopLocation();
            break;
          case "getAddress":
            this.getAddress();
            break;
          case "getGeoCode":
            this.getGeoCode();
            break;
          case "poiSearch":
            this.poiSearch();
            break;
          case "poiNearBySearch":
            this.poiNearBySearch();
            break;
        }
      },
      singleClick() {
        const deviceInfo = uni.getDeviceInfo();
        formatAppLog("log", "at pages/index/index.vue:179", "deviceId：", deviceInfo.deviceId);
        initOption("定位 KEY", deviceInfo.deviceId, true, 0);
        getLocation(
          (res) => {
            formatAppLog("log", "at pages/index/index.vue:183", "index success", res);
            res.timestamp = new Date(res.timestamp).toLocaleString();
            this.wzLocation = res;
            this.sendLocationData();
          },
          (fail) => {
            formatAppLog("log", "at pages/index/index.vue:190", "fail" + fail.code + fail.msg);
          }
        );
      },
      conitueClick() {
        const deviceInfo = uni.getDeviceInfo();
        formatAppLog("log", "at pages/index/index.vue:196", "deviceId：", deviceInfo.deviceId);
        initOption("定位 KEY", deviceInfo.deviceId, false, 1e4);
        getLocation(
          (res) => {
            formatAppLog("log", "at pages/index/index.vue:200", "index success", res);
            res.timestamp = new Date(res.timestamp).toLocaleString();
            this.wzLocation = res;
            this.sendLocationData();
          },
          (fail) => {
            formatAppLog("log", "at pages/index/index.vue:207", "fail" + fail.code + fail.msg);
          }
        );
      },
      getAddress() {
        setAk("定位 KEY");
        getReverseCode(107.191693, 27.945061, "wgs84").then(
          (res) => {
            formatAppLog("log", "at pages/index/index.vue:215", "address : " + res.address.name);
            this.wzLocation.address.name = res.address.name;
            this.sendLocationData();
          },
          (error2) => {
            formatAppLog("log", "at pages/index/index.vue:222", "error : " + error2);
          }
        );
      },
      getGeoCode() {
        setAk("定位 KEY");
        getGeoCode("旺座", "西安市").then(
          (res) => {
            let dataList = res;
            formatAppLog("log", "at pages/index/index.vue:231", dataList[0].geoPoint, dataList[0].address.name);
            this.wzLocation.address.name = dataList[0].address.name;
            this.wzLocation.longitude = dataList[0].geoPoint.split(",")[0];
            this.wzLocation.latitude = dataList[0].geoPoint.split(",")[1];
            this.sendLocationData();
          },
          (error2) => {
            formatAppLog("log", "at pages/index/index.vue:240", "error : ", error2);
          }
        );
      },
      poiSearch() {
        setAk("POI KEY");
        poiSearch("泛悦城T2", "武汉市", 2, 20).then(
          (res) => {
            let dataList = res;
            formatAppLog("log", "at pages/index/index.vue:249", "poi搜索：", dataList);
            formatAppLog("log", "at pages/index/index.vue:250", "poi搜索：", dataList[0].geoPoint, dataList[0].address.name);
            this.wzLocation.address.name = dataList[0].address.name;
            this.wzLocation.longitude = dataList[0].geoPoint.split(",")[0];
            this.wzLocation.latitude = dataList[0].geoPoint.split(",")[1];
            this.sendLocationData();
          },
          (error2) => {
            formatAppLog("log", "at pages/index/index.vue:259", "error : ", error2);
          }
        );
      },
      poiNearBySearch() {
        setAk("POI KEY");
        poiNearbySearch("乒乓球", "体育场馆", "120.59986,31.25979").then(
          (res) => {
            let dataList = res;
            formatAppLog("log", "at pages/index/index.vue:268", "poi搜索：", dataList[0].geoPoint, dataList[0].address.name);
            this.wzLocation.address.name = dataList[0].address.name;
            this.wzLocation.longitude = dataList[0].geoPoint.split(",")[0];
            this.wzLocation.latitude = dataList[0].geoPoint.split(",")[1];
            this.sendLocationData();
          },
          (error2) => {
            formatAppLog("log", "at pages/index/index.vue:277", "error : ", error2);
          }
        );
      },
      stopLocation() {
        stopLocation();
      }
    }
  };
  function _sfc_render$1(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("view", { class: "content" }, [
      vue.createElementVNode("web-view", {
        class: "map-container",
        ref: "webViewRef",
        src: $data.webViewSrc,
        onMessage: _cache[0] || (_cache[0] = (...args) => $options.handleWebMessage && $options.handleWebMessage(...args)),
        onLoad: _cache[1] || (_cache[1] = (...args) => $options.webViewLoad && $options.webViewLoad(...args))
      }, null, 40, ["src"])
    ]);
  }
  const PagesIndexIndex = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["render", _sfc_render$1], ["__scopeId", "data-v-1cf27b2a"], ["__file", "D:/wz_code/uni-sdk-new/uni-app-blank/pages/index/index.vue"]]);
  const _sfc_main$1 = {};
  function _sfc_render(_ctx, _cache) {
    return vue.openBlock(), vue.createElementBlock("view");
  }
  const PagesIndexLocationLocation = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["render", _sfc_render], ["__file", "D:/wz_code/uni-sdk-new/uni-app-blank/pages/index/location/location.vue"]]);
  __definePage("pages/index/index", PagesIndexIndex);
  __definePage("pages/index/location/location", PagesIndexLocationLocation);
  const _sfc_main = {
    onLaunch: function() {
      formatAppLog("log", "at App.vue:4", "App Launch");
    },
    onShow: function() {
      formatAppLog("log", "at App.vue:7", "App Show");
    },
    onHide: function() {
      formatAppLog("log", "at App.vue:10", "App Hide");
    }
  };
  const App = /* @__PURE__ */ _export_sfc(_sfc_main, [["__file", "D:/wz_code/uni-sdk-new/uni-app-blank/App.vue"]]);
  function createApp() {
    const app = vue.createVueApp(App);
    return {
      app
    };
  }
  const { app: __app__, Vuex: __Vuex__, Pinia: __Pinia__ } = createApp();
  uni.Vuex = __Vuex__;
  uni.Pinia = __Pinia__;
  __app__.provide("__globalStyles", __uniConfig.styles);
  __app__._component.mpType = "app";
  __app__._component.render = () => {
  };
  __app__.mount("#app");
})(Vue);
