"use strict";
const common_vendor = require("../../common/vendor.js");
const utils_wz_location = require("../../utils/wz_location.js");
const _sfc_main = {
  data() {
    return {
      webViewSrc: "/static/map/map_view.html",
      webViewReady: false,
      title: "Hello",
      wzLocation: {
        accuracy: 0,
        address: {
          name: "初始地址"
          // 加初始值，方便测试显示
        },
        place: {
          name: "初始位置"
          // 加初始值，方便测试显示
        },
        latitude: 27.945061,
        // 加初始值
        longitude: 107.191693,
        // 加初始值
        source: "",
        spatialReference: "",
        timestamp: (/* @__PURE__ */ new Date()).toLocaleString()
        // 加初始值
      }
    };
  },
  onLoad() {
  },
  methods: {
    // 向 web-view 发送定位数据
    sendLocationData() {
      common_vendor.wx$1.createSelectorQuery().select(".map-container").node((res) => {
        const webview = res.node;
        if (webview) {
          webview.evalJS(`
										window.postMessage({ wzLocation: ${JSON.stringify(this.wzLocation)} });
									`);
        }
      }).exec();
    },
    // 接收 web-view 按钮点击消息
    handleWebMessage(e) {
      common_vendor.index.__f__("log", "at pages/index/index.vue:82", "收到 web-view 消息：", e.detail.data);
      const message = e.detail.data[e.detail.data.length - 1];
      if (!message || !message.type)
        return;
      switch (message.type) {
        case "singleClick":
          this.singleClick();
          break;
        case "conitueClick":
          this.conitueClick();
          break;
        case "stopLocation":
          this.stopLocation();
          break;
        case "getAddress":
          this.getAddress();
          break;
        case "getGeoCode":
          this.getGeoCode();
          break;
        case "poiSearch":
          this.poiSearch();
          break;
        case "poiNearBySearch":
          this.poiNearBySearch();
          break;
      }
    },
    singleClick() {
      const deviceInfo = common_vendor.index.getDeviceInfo();
      common_vendor.index.__f__("log", "at pages/index/index.vue:113", "deviceId：", deviceInfo.deviceId);
      utils_wz_location.initOption("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn", deviceInfo.deviceId, true, 0);
      utils_wz_location.getLocation(
        (res) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:117", "index success", res);
          res.timestamp = new Date(res.timestamp).toLocaleString();
          this.wzLocation = res;
          this.sendLocationData();
        },
        (fail) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:124", "fail" + fail.code + fail.msg);
        }
      );
    },
    conitueClick() {
      const deviceInfo = common_vendor.index.getDeviceInfo();
      common_vendor.index.__f__("log", "at pages/index/index.vue:130", "deviceId：", deviceInfo.deviceId);
      utils_wz_location.initOption("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn", deviceInfo.deviceId, false, 1e4);
      utils_wz_location.getLocation(
        (res) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:134", "index success", res);
          res.timestamp = new Date(res.timestamp).toLocaleString();
          this.wzLocation = res;
          this.sendLocationData();
        },
        (fail) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:141", "fail" + fail.code + fail.msg);
        }
      );
    },
    getAddress() {
      utils_wz_location.setAk("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn");
      utils_wz_location.getReverseCode(107.191693, 27.945061, "wgs84").then(
        (res) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:149", "address : " + res.address.name);
          this.wzLocation.address.name = res.address.name;
          this.sendLocationData();
        },
        (error) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:156", "error : " + error);
        }
      );
    },
    getGeoCode() {
      utils_wz_location.setAk("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn");
      utils_wz_location.getGeoCode("旺座", "西安市").then(
        (res) => {
          let dataList = res;
          common_vendor.index.__f__("log", "at pages/index/index.vue:165", dataList[0].geoPoint, dataList[0].address.name);
          this.wzLocation.address.name = dataList[0].address.name;
          this.wzLocation.longitude = dataList[0].geoPoint.split(",")[0];
          this.wzLocation.latitude = dataList[0].geoPoint.split(",")[1];
          this.sendLocationData();
        },
        (error) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:174", "error : ", error);
        }
      );
    },
    poiSearch() {
      utils_wz_location.setAk("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn");
      utils_wz_location.poiSearch("泛悦城T2", "武汉市", 2, 20).then(
        (res) => {
          let dataList = res;
          common_vendor.index.__f__("log", "at pages/index/index.vue:183", "poi搜索：", dataList);
          common_vendor.index.__f__("log", "at pages/index/index.vue:184", "poi搜索：", dataList[0].geoPoint, dataList[0].address.name);
          this.wzLocation.address.name = dataList[0].address.name;
          this.wzLocation.longitude = dataList[0].geoPoint.split(",")[0];
          this.wzLocation.latitude = dataList[0].geoPoint.split(",")[1];
          this.sendLocationData();
        },
        (error) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:193", "error : ", error);
        }
      );
    },
    poiNearBySearch() {
      utils_wz_location.setAk("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn");
      utils_wz_location.poiNearbySearch("乒乓球", "体育场馆", "120.59986,31.25979").then(
        (res) => {
          let dataList = res;
          common_vendor.index.__f__("log", "at pages/index/index.vue:203", "poi搜索：", dataList[0].geoPoint, dataList[0].address.name);
          this.wzLocation.address.name = dataList[0].address.name;
          this.wzLocation.longitude = dataList[0].geoPoint.split(",")[0];
          this.wzLocation.latitude = dataList[0].geoPoint.split(",")[1];
          this.sendLocationData();
        },
        (error) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:212", "error : ", error);
        }
      );
    },
    stopLocation() {
      utils_wz_location.stopLocation();
    }
  }
};
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  return {
    a: $data.webViewSrc,
    b: common_vendor.o((...args) => $options.handleWebMessage && $options.handleWebMessage(...args))
  };
}
const MiniProgramPage = /* @__PURE__ */ common_vendor._export_sfc(_sfc_main, [["render", _sfc_render], ["__scopeId", "data-v-1cf27b2a"]]);
wx.createPage(MiniProgramPage);
//# sourceMappingURL=../../../.sourcemap/mp-weixin/pages/index/index.js.map
