/*
 * Decompiled with CFR 0.152.
 */
package uts.sdk.modules.uniWifi;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;
import androidx.core.app.ActivityCompat;
import io.dcloud.uniapp.UniError;
import io.dcloud.uts.Map;
import io.dcloud.uts.NumberKt;
import io.dcloud.uts.StringKt;
import io.dcloud.uts.UTSAndroid;
import io.dcloud.uts.UTSArray;
import io.dcloud.uts.UTSArrayKt;
import io.dcloud.uts.UTSCallback;
import io.dcloud.uts.UTSJSONObject;
import io.dcloud.uts.UTSTimerKt;
import io.dcloud.uts.console;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uts.sdk.modules.uniWifi.AndroidUniWifiInfo;
import uts.sdk.modules.uniWifi.CustomBroadcastReceiver;
import uts.sdk.modules.uniWifi.GetConnectedWifiOptions;
import uts.sdk.modules.uniWifi.GetConnectedWifiOptionsJSONObject;
import uts.sdk.modules.uniWifi.Global;
import uts.sdk.modules.uniWifi.IndexKt;
import uts.sdk.modules.uniWifi.UniWifiInfo;
import uts.sdk.modules.uniWifi.UniWifiInfoWithPartialInfo;
import uts.sdk.modules.uniWifi.UniWifiResult;
import uts.sdk.modules.uniWifi.WifiConnectOption;
import uts.sdk.modules.uniWifi.WifiConnectOptionJSONObject;
import uts.sdk.modules.uniWifi.WifiFailImpl;
import uts.sdk.modules.uniWifi.WifiOption;
import uts.sdk.modules.uniWifi.WifiOptionJSONObject;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00b4\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0019\u001a\u0012\u0010\u001a\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u001b\u001a\u00020\u0006\u001a\u000e\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020 \u001a\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"\u001a\u000e\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0001\u001a\u000e\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0001\u001a\u001c\u0010'\u001a\u00020\u00112\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010)j\u0004\u0018\u0001`*\u001a\u0010\u0010+\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010,\u001a1\u0010-\u001a\u00020\u00112)\u0010(\u001a%\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u0011\u0018\u00010.j\u0004\u0018\u0001`3\u001a\u0010\u00104\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010,\u001a1\u00105\u001a\u00020\u00112)\u0010(\u001a%\u0012\u0013\u0012\u001106\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u0011\u0018\u00010.j\u0004\u0018\u0001`7\u001a\u0010\u00108\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010,\u001a-\u00109\u001a\u00020\u00112%\u0010(\u001a!\u0012\u0013\u0012\u00110:\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00110.j\u0002`;\u001a\u000e\u0010<\u001a\u00020\u00112\u0006\u0010(\u001a\u00020,\u001a-\u0010=\u001a\u00020\u00112%\u0010(\u001a!\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00110.j\u0002`3\u001a\u000e\u0010>\u001a\u00020\u00112\u0006\u0010(\u001a\u00020,\u001a-\u0010?\u001a\u00020\u00112%\u0010(\u001a!\u0012\u0013\u0012\u001106\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00110.j\u0002`7\u001a\u000e\u0010@\u001a\u00020\u00112\u0006\u0010(\u001a\u00020,\u001a\u000e\u0010A\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010B\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020 \u001a\u000e\u0010C\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"\u001a\u000e\u0010D\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020 \u001a\u000e\u0010E\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"\u001a\u000e\u0010F\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020 \u001a\u000e\u0010G\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"\u001a\u000e\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K\u001a\u000e\u0010L\u001a\u00020I2\u0006\u0010M\u001a\u00020N\u001a\u000e\u0010O\u001a\u00020K2\u0006\u0010P\u001a\u00020\u001e\u001a \u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u00012\b\u0010T\u001a\u0004\u0018\u00010\u00012\u0006\u0010U\u001a\u00020\u0001\u001a\u0010\u0010V\u001a\u00020\u00062\b\u0010W\u001a\u0004\u0018\u00010\u0001\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"!\u0010\u0004\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f*@\u0010X\"\u001d\u0012\u0013\u0012\u00110:\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00110.2\u001d\u0012\u0013\u0012\u00110:\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00110.*\u0016\u0010Y\"\b\u0012\u0004\u0012\u00020\u00110)2\b\u0012\u0004\u0012\u00020\u00110)*@\u0010Z\"\u001d\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00110.2\u001d\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00110.*@\u0010[\"\u001d\u0012\u0013\u0012\u001106\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00110.2\u001d\u0012\u0013\u0012\u001106\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00110.*\n\u0010\\\"\u00020\u00062\u00020\u0006"}, d2={"UniErrorSubject", "", "getUniErrorSubject", "()Ljava/lang/String;", "WifiUniErrors", "Lio/dcloud/uts/Map;", "", "Luts/sdk/modules/uniWifi/WifiErrorCode;", "getWifiUniErrors", "()Lio/dcloud/uts/Map;", "startWifiScaning", "", "getStartWifiScaning", "()Z", "setStartWifiScaning", "(Z)V", "connectWifi", "", "option", "Luts/sdk/modules/uniWifi/WifiConnectOption;", "connectWifiByJs", "Luts/sdk/modules/uniWifi/WifiConnectOptionJSONObject;", "getConnectedWifi", "Luts/sdk/modules/uniWifi/GetConnectedWifiOptions;", "getConnectedWifiByJs", "Luts/sdk/modules/uniWifi/GetConnectedWifiOptionsJSONObject;", "getErrcode", "errCode", "getSecurityType", "result", "Landroid/net/wifi/ScanResult;", "getWifiList", "Luts/sdk/modules/uniWifi/WifiOption;", "getWifiListByJs", "Luts/sdk/modules/uniWifi/WifiOptionJSONObject;", "isHex", "key", "isHexWepKey", "wepKey", "offGetWifiList", "callback", "Lkotlin/Function0;", "Luts/sdk/modules/uniWifi/UniWifiCallback;", "offGetWifiListByJs", "Lio/dcloud/uts/UTSCallback;", "offWifiConnected", "Lkotlin/Function1;", "Luts/sdk/modules/uniWifi/UniWifiResult;", "Lkotlin/ParameterName;", "name", "wifiInfo", "Luts/sdk/modules/uniWifi/UniWifiResultCallback;", "offWifiConnectedByJs", "offWifiConnectedWithPartialInfo", "Luts/sdk/modules/uniWifi/UniWifiInfoWithPartialInfo;", "Luts/sdk/modules/uniWifi/UniWifiResultCallbackWithPartialInfo;", "offWifiConnectedWithPartialInfoByJs", "onGetWifiList", "Lio/dcloud/uts/UTSJSONObject;", "Luts/sdk/modules/uniWifi/UniGetWifiListCallback;", "onGetWifiListByJs", "onWifiConnected", "onWifiConnectedByJs", "onWifiConnectedWithPartialInfo", "onWifiConnectedWithPartialInfoByJs", "realWifiConnect", "startWifi", "startWifiByJs", "startWifiImpl", "startWifiImplByJs", "stopWifi", "stopWifiByJs", "wrapUniWifiInfoFromAndroid", "Luts/sdk/modules/uniWifi/UniWifiInfo;", "androidInfo", "Luts/sdk/modules/uniWifi/AndroidUniWifiInfo;", "wrapUniWifiInfoFromConnectInfo", "connectInfo", "Landroid/net/wifi/WifiInfo;", "wrapUniWifiInfoFromScan", "scanResult", "wrapWifiConfiguration", "Landroid/net/wifi/WifiConfiguration;", "SSID", "password", "passwordType", "zeroCountNum", "source", "UniGetWifiListCallback", "UniWifiCallback", "UniWifiResultCallback", "UniWifiResultCallbackWithPartialInfo", "WifiErrorCode"})
@SourceDebugExtension(value={"SMAP\nindex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 index.kt\nuts/sdk/modules/uniWifi/IndexKt\n+ 2 UTSArray.kt\nio/dcloud/uts/UTSArrayKt\n*L\n1#1,777:1\n14#2:778\n14#2:779\n14#2:780\n14#2:781\n*S KotlinDebug\n*F\n+ 1 index.kt\nuts/sdk/modules/uniWifi/IndexKt\n*L\n445#1:778\n455#1:779\n600#1:780\n601#1:781\n*E\n"})
public final class IndexKt {
    @NotNull
    private static final String UniErrorSubject = "uni-wifi";
    @NotNull
    private static final Map<Number, String> WifiUniErrors;
    private static boolean startWifiScaning;

    @NotNull
    public static final String getUniErrorSubject() {
        return UniErrorSubject;
    }

    @NotNull
    public static final Map<Number, String> getWifiUniErrors() {
        return WifiUniErrors;
    }

    @NotNull
    public static final Number getErrcode(@NotNull Number errCode) {
        Intrinsics.checkNotNullParameter((Object)errCode, (String)"errCode");
        String res = (String)WifiUniErrors.get((Object)errCode);
        return res == null ? (Number)12000 : (Number)errCode;
    }

    public static final boolean isHex(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean bl = false;
        for (int i = key.length() - 1; i >= 0; --i) {
            String c = StringKt.charAt((String)key, (Number)i);
            if (c.compareTo("0") >= 0 && c.compareTo("9") <= 0 || c.compareTo("A") >= 0 && c.compareTo("F") <= 0 || c.compareTo("a") >= 0 && c.compareTo("f") <= 0) continue;
            return false;
        }
        return true;
    }

    public static final boolean isHexWepKey(@NotNull String wepKey) {
        Intrinsics.checkNotNullParameter((Object)wepKey, (String)"wepKey");
        int len = wepKey.length();
        if (len != 10 && len != 26 && len != 58) {
            return false;
        }
        return IndexKt.isHex(wepKey);
    }

    @NotNull
    public static final UniWifiInfo wrapUniWifiInfoFromAndroid(@NotNull AndroidUniWifiInfo androidInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)androidInfo), (String)"androidInfo");
        UniWifiInfo ret = new UniWifiInfo(androidInfo.getSSID(), androidInfo.getBSSID(), androidInfo.getSecure(), androidInfo.getSignalStrength(), androidInfo.getFrequency());
        return ret;
    }

    @NotNull
    public static final AndroidUniWifiInfo wrapUniWifiInfoFromScan(@NotNull ScanResult scanResult) {
        Intrinsics.checkNotNullParameter((Object)scanResult, (String)"scanResult");
        AndroidUniWifiInfo ret = new AndroidUniWifiInfo("", null, false, 0, 0, "NONE", 2, null);
        ret.setBSSID(scanResult.BSSID);
        String string = scanResult.SSID;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SSID");
        ret.setSSID(string);
        ret.setSignalStrength(scanResult.level);
        ret.setFrequency(scanResult.frequency);
        ret.setSecure(false);
        String string2 = scanResult.capabilities;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capabilities");
        String capabilities = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (capabilities.equals(Global.Companion.getWIFI_AUTH_OPEN()) || capabilities.equals(Global.Companion.getWIFI_AUTH_ROAM())) {
            ret.setSecure(false);
        } else {
            ret.setSecure(true);
        }
        ret.setSecurityType(IndexKt.getSecurityType(scanResult));
        return ret;
    }

    @NotNull
    public static final UniWifiInfo wrapUniWifiInfoFromConnectInfo(@NotNull WifiInfo connectInfo) {
        Intrinsics.checkNotNullParameter((Object)connectInfo, (String)"connectInfo");
        UniWifiInfo ret = new UniWifiInfo("", null, false, 0, 0, 2, null);
        if (connectInfo.getSSID() != null) {
            String string;
            String s = connectInfo.getSSID();
            if (s.length() > 2) {
                string = s;
                Intrinsics.checkNotNull((Object)string);
                if (Intrinsics.areEqual((Object)StringKt.charAt((String)string, (Number)0), (Object)"\"")) {
                    string = s;
                    Intrinsics.checkNotNull((Object)string);
                    if (Intrinsics.areEqual((Object)StringKt.charAt((String)string, (Number)(s.length() - 1)), (Object)"\"")) {
                        string = s;
                        Intrinsics.checkNotNull((Object)string);
                        s = StringKt.substring((String)string, (Number)1, (Number)(s.length() - 1));
                    }
                }
            }
            string = s;
            Intrinsics.checkNotNull((Object)string);
            ret.setSSID(string);
        }
        ret.setBSSID(connectInfo.getBSSID());
        ret.setSignalStrength(connectInfo.getRssi() + 100);
        ret.setFrequency(connectInfo.getFrequency());
        return ret;
    }

    @NotNull
    public static final WifiConfiguration wrapWifiConfiguration(@NotNull String SSID, @Nullable String password, @NotNull String passwordType) {
        Intrinsics.checkNotNullParameter((Object)SSID, (String)"SSID");
        Intrinsics.checkNotNullParameter((Object)passwordType, (String)"passwordType");
        WifiConfiguration config = new WifiConfiguration();
        config.status = 2;
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        String[] stringArray = new String[]{SSID};
        String string = StringKt.concat((String)"\"", (String[])stringArray);
        stringArray = new String[]{"\""};
        config.SSID = StringKt.concat((String)string, (String[])stringArray);
        if ("NONE".equals(passwordType) || password == null) {
            config.allowedKeyManagement.set(0);
        } else if ("WEP".equals(passwordType)) {
            if (!TextUtils.isEmpty((CharSequence)password)) {
                if (IndexKt.isHexWepKey(password)) {
                    config.wepKeys[0] = password;
                } else {
                    stringArray = new String[]{password};
                    String string2 = StringKt.concat((String)"\"", (String[])stringArray);
                    stringArray = new String[]{"\""};
                    config.wepKeys[0] = StringKt.concat((String)string2, (String[])stringArray);
                }
            }
            config.allowedAuthAlgorithms.set(0);
            config.allowedAuthAlgorithms.set(1);
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        } else if ("WPA".equals(passwordType)) {
            config.allowedProtocols.set(1);
            config.allowedProtocols.set(0);
            config.allowedKeyManagement.set(1);
            config.allowedPairwiseCiphers.set(2);
            config.allowedPairwiseCiphers.set(1);
            config.allowedGroupCiphers.set(0);
            config.allowedGroupCiphers.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedGroupCiphers.set(2);
            stringArray = new String[]{password};
            String string3 = StringKt.concat((String)"\"", (String[])stringArray);
            stringArray = new String[]{"\""};
            config.preSharedKey = StringKt.concat((String)string3, (String[])stringArray);
        }
        return config;
    }

    @NotNull
    public static final String getSecurityType(@NotNull ScanResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String string = result.capabilities;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capabilities");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"WEP", (boolean)false, (int)2, null)) {
            return "WEP";
        }
        String string2 = result.capabilities;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capabilities");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"PSK", (boolean)false, (int)2, null)) {
            return "WPA";
        }
        String string3 = result.capabilities;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"capabilities");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"EAP", (boolean)false, (int)2, null)) {
            return "EAP";
        }
        return "NONE";
    }

    @NotNull
    public static final Number zeroCountNum(@Nullable String source) {
        if (source == null) {
            return 0;
        }
        UTSArray splitted = StringKt.split((String)source, (String)":");
        Number countNum = 0;
        for (String perItem : splitted) {
            switch (perItem.hashCode()) {
                case 1536: {
                    if (!perItem.equals("00")) break;
                    countNum = NumberKt.plus((Number)countNum, (Number)1);
                }
            }
        }
        return countNum;
    }

    public static final boolean getStartWifiScaning() {
        return startWifiScaning;
    }

    public static final void setStartWifiScaning(boolean bl) {
        startWifiScaning = bl;
    }

    public static final void startWifiImpl(@NotNull WifiOption option) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
            Context context = UTSAndroid.INSTANCE.getAppContext();
            Intrinsics.checkNotNull((Object)context);
            Object object = context.getSystemService("wifi");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.wifi.WifiManager");
            WifiManager wifiManager = (WifiManager)object;
            if (!wifiManager.isWifiEnabled()) {
                WifiFailImpl failResult = new WifiFailImpl(IndexKt.getErrcode(12005));
                Function1<UniError, Unit> function1 = option.getFail();
                if (function1 != null) {
                    function1.invoke((Object)failResult);
                }
                Function1<Object, Unit> function12 = option.getComplete();
                if (function12 != null) {
                    function12.invoke((Object)failResult);
                }
                return;
            }
            if (Global.Companion.getMReceiver() != null) {
                UniWifiResult result = new UniWifiResult(0, UniErrorSubject, "startWifi:ok", null);
                Function1<UniWifiResult, Unit> function1 = option.getSuccess();
                if (function1 != null) {
                    function1.invoke((Object)result);
                }
                Function1<Object, Unit> function13 = option.getComplete();
                if (function13 != null) {
                    function13.invoke((Object)result);
                }
                return;
            }
            Global.Companion.setMReceiver(new CustomBroadcastReceiver(wifiManager));
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.wifi.SCAN_RESULTS");
            filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
            filter.addAction("android.net.wifi.supplicant.STATE_CHANGE");
            Activity activity = UTSAndroid.INSTANCE.getUniActivity();
            Intrinsics.checkNotNull((Object)activity);
            activity.registerReceiver((BroadcastReceiver)Global.Companion.getMReceiver(), filter);
            UTSAndroid.INSTANCE.onAppActivityDestroy((Function0)startWifiImpl.1.INSTANCE);
            startWifiScaning = true;
            wifiManager.startScan();
            UniWifiResult result = new UniWifiResult(0, UniErrorSubject, "startWifi:ok", null);
            Function1<UniWifiResult, Unit> function1 = option.getSuccess();
            if (function1 != null) {
                function1.invoke((Object)result);
            }
            Function1<Object, Unit> function14 = option.getComplete();
            if (function14 == null) break block7;
            function14.invoke((Object)result);
        }
    }

    public static final void startWifi(@NotNull WifiOption option) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        Object[] objectArray = new String[]{"android.permission.ACCESS_FINE_LOCATION"};
        UTSArray permissionNeed = UTSArrayKt.utsArrayOf((Object[])objectArray);
        Activity activity = UTSAndroid.INSTANCE.getUniActivity();
        Intrinsics.checkNotNull((Object)activity);
        UTSAndroid.INSTANCE.requestSystemPermission(activity, permissionNeed, (Function2)new Function2<Boolean, UTSArray<String>, Unit>(option){
            final /* synthetic */ WifiOption $option;
            {
                this.$option = $option;
                super(2);
            }

            public final void invoke(boolean allRight, @NotNull UTSArray<String> _grantedList) {
                Intrinsics.checkNotNullParameter(_grantedList, (String)"_grantedList");
                if (allRight) {
                    IndexKt.startWifiImpl(this.$option);
                }
            }
        }, (Function2)new Function2<Boolean, UTSArray<String>, Unit>(option){
            final /* synthetic */ WifiOption $option;
            {
                this.$option = $option;
                super(2);
            }

            public final void invoke(boolean _doNotAskAgain, @NotNull UTSArray<String> _grantedList) {
                block1: {
                    Intrinsics.checkNotNullParameter(_grantedList, (String)"_grantedList");
                    WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12001));
                    Function1<UniError, Unit> function1 = this.$option.getFail();
                    if (function1 != null) {
                        function1.invoke((Object)err);
                    }
                    Function1<Object, Unit> function12 = this.$option.getComplete();
                    if (function12 == null) break block1;
                    function12.invoke((Object)err);
                }
            }
        });
    }

    public static final void getWifiList(@NotNull WifiOption option) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        if (Global.Companion.getMReceiver() == null) {
            WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12000));
            Function1<UniError, Unit> function1 = option.getFail();
            if (function1 != null) {
                function1.invoke((Object)err);
            }
            Function1<Object, Unit> function12 = option.getComplete();
            if (function12 != null) {
                function12.invoke((Object)err);
            }
            return;
        }
        Context context = UTSAndroid.INSTANCE.getAppContext();
        Intrinsics.checkNotNull((Object)context);
        Object object = context.getSystemService("wifi");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.wifi.WifiManager");
        WifiManager wifiManager = (WifiManager)object;
        if (option.getSuccess() != null) {
            Global.Companion.setSupendGetWifiSuccess(option.getSuccess());
        }
        if (option.getComplete() != null) {
            Global.Companion.setSupendGetWifiComplete(option.getComplete());
        }
        wifiManager.startScan();
    }

    public static final void onWifiConnected(@NotNull Function1<? super UniWifiResult, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Object[] objectArray = new Function1[]{callback};
        Global.Companion.getOnWifiConnectCallbackList().push(objectArray);
    }

    public static final void onWifiConnectedWithPartialInfo(@NotNull Function1<? super UniWifiInfoWithPartialInfo, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Object[] objectArray = new Function1[]{callback};
        Global.Companion.getOnWifiConnectWithPartialInfoCallbackList().push(objectArray);
    }

    public static final void offWifiConnected(@Nullable Function1<? super UniWifiResult, Unit> callback) {
        if (callback == null) {
            boolean $i$f$utsArrayOf = false;
            Global.Companion.setOnWifiConnectCallbackList((UTSArray<Function1<UniWifiResult, Unit>>)new UTSArray());
            return;
        }
        int callbackIndex = Global.Companion.getOnWifiConnectCallbackList().indexOf(callback);
        if (callbackIndex >= 0) {
            Global.Companion.getOnWifiConnectCallbackList().splice((Number)callbackIndex, (Number)1);
        }
    }

    public static final void offWifiConnectedWithPartialInfo(@Nullable Function1<? super UniWifiInfoWithPartialInfo, Unit> callback) {
        if (callback == null) {
            boolean $i$f$utsArrayOf = false;
            Global.Companion.setOnWifiConnectWithPartialInfoCallbackList((UTSArray<Function1<UniWifiInfoWithPartialInfo, Unit>>)new UTSArray());
            return;
        }
        int callbackIndex = Global.Companion.getOnWifiConnectWithPartialInfoCallbackList().indexOf(callback);
        if (callbackIndex >= 0) {
            Global.Companion.getOnWifiConnectWithPartialInfoCallbackList().splice((Number)callbackIndex, (Number)1);
        }
    }

    public static final void onGetWifiList(@NotNull Function1<? super UTSJSONObject, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Global.Companion.setOnGetWifiListCallback(callback);
    }

    public static final void offGetWifiList(@Nullable Function0<Unit> callback) {
        Global.Companion.setOnGetWifiListCallback(null);
        Global.Companion.setSupendGetWifiComplete(null);
        Global.Companion.setSupendGetWifiSuccess(null);
    }

    public static final void realWifiConnect(@NotNull WifiConnectOption option) {
        block31: {
            boolean removeRet;
            Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
            if (Global.Companion.getMReceiver() == null || NumberKt.compareTo((Number)Global.Companion.getScanList().getLength(), (Number)1) < 0) {
                WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12000));
                Function1<UniError, Unit> function1 = option.getFail();
                if (function1 != null) {
                    function1.invoke((Object)err);
                }
                Function1<Object, Unit> function12 = option.getComplete();
                if (function12 != null) {
                    function12.invoke((Object)err);
                }
                return;
            }
            AndroidUniWifiInfo scanWifiInfo = null;
            for (AndroidUniWifiInfo scanResult : Global.Companion.getScanList()) {
                if (!scanResult.getSSID().equals(option.getSSID())) continue;
                scanWifiInfo = scanResult;
            }
            if (scanWifiInfo == null) {
                WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12000));
                Function1<UniError, Unit> function1 = option.getFail();
                if (function1 != null) {
                    function1.invoke((Object)err);
                }
                Function1<Object, Unit> function13 = option.getComplete();
                if (function13 != null) {
                    function13.invoke((Object)err);
                }
                return;
            }
            WifiConfiguration wifiConfigration = IndexKt.wrapWifiConfiguration(scanWifiInfo.getSSID(), option.getPassword(), scanWifiInfo.getSecurityType());
            wifiConfigration.BSSID = scanWifiInfo.getBSSID();
            Context context = UTSAndroid.INSTANCE.getAppContext();
            Intrinsics.checkNotNull((Object)context);
            Object object = context.getSystemService("wifi");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.wifi.WifiManager");
            WifiManager wifiManager = (WifiManager)object;
            WifiConfiguration targetExistConfig = null;
            List existingConfigs = wifiManager.getConfiguredNetworks();
            for (WifiConfiguration existingConfig : existingConfigs) {
                if (!existingConfig.SSID.equals('\"' + option.getSSID() + '\"')) continue;
                targetExistConfig = existingConfig;
            }
            if (targetExistConfig != null && !(removeRet = wifiManager.removeNetwork(targetExistConfig.networkId))) {
                WifiFailImpl err;
                if (Build.VERSION.SDK_INT > 28) {
                    err = new WifiFailImpl(IndexKt.getErrcode(12001));
                    Function1<UniError, Unit> function1 = option.getFail();
                    if (function1 != null) {
                        function1.invoke((Object)err);
                    }
                    Function1<Object, Unit> function14 = option.getComplete();
                    if (function14 != null) {
                        function14.invoke((Object)err);
                    }
                } else {
                    err = new WifiFailImpl(IndexKt.getErrcode(12013));
                    Function1<UniError, Unit> function1 = option.getFail();
                    if (function1 != null) {
                        function1.invoke((Object)err);
                    }
                    Function1<Object, Unit> function15 = option.getComplete();
                    if (function15 != null) {
                        function15.invoke((Object)err);
                    }
                }
                return;
            }
            WifiInfo currentConnect = wifiManager.getConnectionInfo();
            if (currentConnect.getNetworkId() >= 0) {
                wifiManager.disableNetwork(currentConnect.getNetworkId());
            } else {
                wifiManager.removeNetwork(currentConnect.getNetworkId());
            }
            wifiManager.disconnect();
            boolean connected = false;
            try {
                int netID = wifiManager.addNetwork(wifiConfigration);
                if (netID < 0) {
                    WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12002));
                    Function1<UniError, Unit> function1 = option.getFail();
                    if (function1 != null) {
                        function1.invoke((Object)err);
                    }
                    Function1<Object, Unit> function16 = option.getComplete();
                    if (function16 != null) {
                        function16.invoke((Object)err);
                    }
                    return;
                }
                boolean enabled = wifiManager.enableNetwork(netID, true);
                if (!enabled) {
                    WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12007));
                    Function1<UniError, Unit> function1 = option.getFail();
                    if (function1 != null) {
                        function1.invoke((Object)err);
                    }
                    Function1<Object, Unit> function17 = option.getComplete();
                    if (function17 != null) {
                        function17.invoke((Object)err);
                    }
                    return;
                }
                connected = wifiManager.reconnect();
            }
            catch (Throwable e) {
                connected = false;
                Object[] enabled = new Object[]{e, " at uni_modules/uni-wifi/utssdk/app-android/index.uts:625"};
                console.Companion.log(enabled);
            }
            if (!connected) {
                WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12010));
                Function1<UniError, Unit> function1 = option.getFail();
                if (function1 != null) {
                    function1.invoke((Object)err);
                }
                Function1<Object, Unit> function18 = option.getComplete();
                if (function18 != null) {
                    function18.invoke((Object)err);
                }
                return;
            }
            UniWifiResult result = new UniWifiResult(0, UniErrorSubject, "getWifiList:ok", null);
            wifiManager.saveConfiguration();
            if (option.getPartialInfo() != null && Intrinsics.areEqual((Object)option.getPartialInfo(), (Object)true)) {
                UniWifiInfo wifiPartialInfo = new UniWifiInfo(scanWifiInfo.getSSID(), null, null, null, null, 30, null);
                result.setWifi(wifiPartialInfo);
            } else {
                result.setWifi(IndexKt.wrapUniWifiInfoFromAndroid(scanWifiInfo));
            }
            Function1<UniWifiResult, Unit> function1 = option.getSuccess();
            if (function1 != null) {
                function1.invoke((Object)result);
            }
            Function1<Object, Unit> function19 = option.getComplete();
            if (function19 == null) break block31;
            function19.invoke((Object)result);
        }
    }

    public static final void connectWifi(@NotNull WifiConnectOption option) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        if (Intrinsics.areEqual((Object)option.getMaunal(), (Object)true)) {
            Intent manunalIntent = new Intent("android.settings.WIFI_SETTINGS");
            Activity activity = UTSAndroid.INSTANCE.getUniActivity();
            Intrinsics.checkNotNull((Object)activity);
            activity.startActivity(manunalIntent);
            UniWifiResult result = new UniWifiResult(0, UniErrorSubject, "connectWifi:ok", null);
            Function1<UniWifiResult, Unit> function1 = option.getSuccess();
            if (function1 != null) {
                function1.invoke((Object)result);
            }
            Function1<Object, Unit> function12 = option.getComplete();
            if (function12 != null) {
                function12.invoke((Object)result);
            }
            return;
        }
        if (startWifiScaning) {
            Ref.ObjectRef taskCount = new Ref.ObjectRef();
            taskCount.element = 0;
            Ref.ObjectRef taskId = new Ref.ObjectRef();
            taskId.element = 0;
            taskId.element = UTSTimerKt.setInterval((Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<Number>)taskCount, (Ref.ObjectRef<Number>)taskId, option){
                final /* synthetic */ Ref.ObjectRef<Number> $taskCount;
                final /* synthetic */ Ref.ObjectRef<Number> $taskId;
                final /* synthetic */ WifiConnectOption $option;
                {
                    this.$taskCount = $taskCount;
                    this.$taskId = $taskId;
                    this.$option = $option;
                    super(0);
                }

                public final void invoke() {
                    this.$taskCount.element = NumberKt.plus((Number)((Number)this.$taskCount.element), (Number)1);
                    if (NumberKt.compareTo((Number)((Number)this.$taskCount.element), (Number)5) >= 0 || !IndexKt.getStartWifiScaning()) {
                        UTSTimerKt.clearInterval((Number)((Number)this.$taskId.element));
                        IndexKt.realWifiConnect(this.$option);
                    }
                }
            }), (Number)2000);
            UTSAndroid.INSTANCE.onAppActivityDestroy((Function0)new Function0<Unit>((Ref.ObjectRef<Number>)taskId){
                final /* synthetic */ Ref.ObjectRef<Number> $taskId;
                {
                    this.$taskId = $taskId;
                    super(0);
                }

                public final void invoke() {
                    UTSTimerKt.clearInterval((Number)((Number)this.$taskId.element));
                }
            });
        } else {
            IndexKt.realWifiConnect(option);
        }
    }

    public static final void stopWifi(@NotNull WifiOption option) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
            if (Global.Companion.getMReceiver() == null) {
                WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12000));
                Function1<UniError, Unit> function1 = option.getFail();
                if (function1 != null) {
                    function1.invoke((Object)err);
                }
                Function1<Object, Unit> function12 = option.getComplete();
                if (function12 != null) {
                    function12.invoke((Object)err);
                }
                return;
            }
            try {
                Activity activity = UTSAndroid.INSTANCE.getUniActivity();
                Intrinsics.checkNotNull((Object)activity);
                activity.unregisterReceiver((BroadcastReceiver)Global.Companion.getMReceiver());
            }
            catch (Throwable err) {
                // empty catch block
            }
            Global.Companion.setOnGetWifiListCallback(null);
            boolean $i$f$utsArrayOf = false;
            Global.Companion.setOnWifiConnectWithPartialInfoCallbackList((UTSArray<Function1<UniWifiInfoWithPartialInfo, Unit>>)new UTSArray());
            $i$f$utsArrayOf = false;
            Global.Companion.setOnWifiConnectCallbackList((UTSArray<Function1<UniWifiResult, Unit>>)new UTSArray());
            Global.Companion.setMReceiver(null);
            UniWifiResult ret = new UniWifiResult(0, UniErrorSubject, "stopWifi:ok", null);
            Function1<UniWifiResult, Unit> function1 = option.getSuccess();
            if (function1 != null) {
                function1.invoke((Object)ret);
            }
            Function1<Object, Unit> function13 = option.getComplete();
            if (function13 == null) break block6;
            function13.invoke((Object)ret);
        }
    }

    public static final void getConnectedWifi(@NotNull GetConnectedWifiOptions option) {
        block15: {
            Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
            UniWifiInfo wifiInfo = new UniWifiInfo("", null, null, null, null, 30, null);
            if (Global.Companion.getMReceiver() == null) {
                WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12000));
                Function1<UniError, Unit> function1 = option.getFail();
                if (function1 != null) {
                    function1.invoke((Object)err);
                }
                Function1<Object, Unit> function12 = option.getComplete();
                if (function12 != null) {
                    function12.invoke((Object)err);
                }
                return;
            }
            Activity activity = UTSAndroid.INSTANCE.getUniActivity();
            Intrinsics.checkNotNull((Object)activity);
            if (ActivityCompat.checkSelfPermission((Context)((Context)activity), (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
                WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12001));
                Function1<UniError, Unit> function1 = option.getFail();
                if (function1 != null) {
                    function1.invoke((Object)err);
                }
                Function1<Object, Unit> function13 = option.getComplete();
                if (function13 != null) {
                    function13.invoke((Object)err);
                }
                return;
            }
            Context context = UTSAndroid.INSTANCE.getAppContext();
            if (context != null) {
                Object object = context.getSystemService("wifi");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.wifi.WifiManager");
                WifiManager wm = (WifiManager)object;
                WifiInfo winfo = wm.getConnectionInfo();
                Intrinsics.checkNotNull((Object)winfo);
                wifiInfo = IndexKt.wrapUniWifiInfoFromConnectInfo(winfo);
                UniWifiResult res = new UniWifiResult(0, UniErrorSubject, "getConnectedWifi:ok", null);
                if (option.getPartialInfo() != null) {
                    UniWifiInfo ret = new UniWifiInfo(wifiInfo.getSSID(), null, null, null, null, 30, null);
                    res.setWifi(ret);
                } else {
                    if (wifiInfo.getBSSID() == null || NumberKt.compareTo((Number)IndexKt.zeroCountNum(wifiInfo.getBSSID()), (Number)3) > 0) {
                        WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12005));
                        Function1<UniError, Unit> function1 = option.getFail();
                        if (function1 != null) {
                            function1.invoke((Object)err);
                        }
                        Function1<Object, Unit> function14 = option.getComplete();
                        if (function14 != null) {
                            function14.invoke((Object)err);
                        }
                        return;
                    }
                    res.setWifi(wifiInfo);
                }
                Function1<UniWifiResult, Unit> function1 = option.getSuccess();
                if (function1 != null) {
                    function1.invoke((Object)res);
                }
                Function1<Object, Unit> function15 = option.getComplete();
                if (function15 != null) {
                    function15.invoke((Object)res);
                }
                return;
            }
            WifiFailImpl err = new WifiFailImpl(IndexKt.getErrcode(12000));
            Function1<UniError, Unit> function1 = option.getFail();
            if (function1 != null) {
                function1.invoke((Object)err);
            }
            Function1<Object, Unit> function16 = option.getComplete();
            if (function16 == null) break block15;
            function16.invoke((Object)err);
        }
    }

    public static final void startWifiImplByJs(@NotNull WifiOptionJSONObject option) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        IndexKt.startWifiImpl(new WifiOption((Function1<? super UniWifiResult, Unit>)((Function1)new Function1<UniWifiResult, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniWifiResult res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)res), (String)"res");
                    UTSCallback uTSCallback = this.$option.getSuccess();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<? super UniError, Unit>)((Function1)new Function1<UniError, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniError res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getFail();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull Object res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getComplete();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        })));
    }

    public static final void startWifiByJs(@NotNull WifiOptionJSONObject option) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        IndexKt.startWifi(new WifiOption((Function1<? super UniWifiResult, Unit>)((Function1)new Function1<UniWifiResult, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniWifiResult res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)res), (String)"res");
                    UTSCallback uTSCallback = this.$option.getSuccess();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<? super UniError, Unit>)((Function1)new Function1<UniError, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniError res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getFail();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull Object res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getComplete();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        })));
    }

    public static final void getWifiListByJs(@NotNull WifiOptionJSONObject option) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        IndexKt.getWifiList(new WifiOption((Function1<? super UniWifiResult, Unit>)((Function1)new Function1<UniWifiResult, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniWifiResult res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)res), (String)"res");
                    UTSCallback uTSCallback = this.$option.getSuccess();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<? super UniError, Unit>)((Function1)new Function1<UniError, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniError res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getFail();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull Object res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getComplete();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        })));
    }

    public static final void onWifiConnectedByJs(@NotNull UTSCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IndexKt.onWifiConnected((Function1<? super UniWifiResult, Unit>)((Function1)new Function1<UniWifiResult, Unit>(callback){
            final /* synthetic */ UTSCallback $callback;
            {
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(@NotNull UniWifiResult wifiInfo) {
                Intrinsics.checkNotNullParameter((Object)((Object)wifiInfo), (String)"wifiInfo");
                Object[] objectArray = new Object[]{wifiInfo};
                this.$callback.invoke(objectArray);
            }
        }));
    }

    public static final void onWifiConnectedWithPartialInfoByJs(@NotNull UTSCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IndexKt.onWifiConnectedWithPartialInfo((Function1<? super UniWifiInfoWithPartialInfo, Unit>)((Function1)new Function1<UniWifiInfoWithPartialInfo, Unit>(callback){
            final /* synthetic */ UTSCallback $callback;
            {
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(@NotNull UniWifiInfoWithPartialInfo wifiInfo) {
                Intrinsics.checkNotNullParameter((Object)((Object)wifiInfo), (String)"wifiInfo");
                Object[] objectArray = new Object[]{wifiInfo};
                this.$callback.invoke(objectArray);
            }
        }));
    }

    public static final void offWifiConnectedByJs(@Nullable UTSCallback callback) {
        IndexKt.offWifiConnected((Function1<? super UniWifiResult, Unit>)((Function1)new Function1<UniWifiResult, Unit>(callback){
            final /* synthetic */ UTSCallback $callback;
            {
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(@NotNull UniWifiResult wifiInfo) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)wifiInfo), (String)"wifiInfo");
                    UTSCallback uTSCallback = this.$callback;
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{wifiInfo};
                    uTSCallback.invoke(objectArray);
                }
            }
        }));
    }

    public static final void offWifiConnectedWithPartialInfoByJs(@Nullable UTSCallback callback) {
        IndexKt.offWifiConnectedWithPartialInfo((Function1<? super UniWifiInfoWithPartialInfo, Unit>)((Function1)new Function1<UniWifiInfoWithPartialInfo, Unit>(callback){
            final /* synthetic */ UTSCallback $callback;
            {
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(@NotNull UniWifiInfoWithPartialInfo wifiInfo) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)wifiInfo), (String)"wifiInfo");
                    UTSCallback uTSCallback = this.$callback;
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{wifiInfo};
                    uTSCallback.invoke(objectArray);
                }
            }
        }));
    }

    public static final void onGetWifiListByJs(@NotNull UTSCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IndexKt.onGetWifiList((Function1<? super UTSJSONObject, Unit>)((Function1)new Function1<UTSJSONObject, Unit>(callback){
            final /* synthetic */ UTSCallback $callback;
            {
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(@NotNull UTSJSONObject wifiInfo) {
                Intrinsics.checkNotNullParameter((Object)wifiInfo, (String)"wifiInfo");
                Object[] objectArray = new Object[]{wifiInfo};
                this.$callback.invoke(objectArray);
            }
        }));
    }

    public static final void offGetWifiListByJs(@Nullable UTSCallback callback) {
        IndexKt.offGetWifiList((Function0<Unit>)((Function0)new Function0<Unit>(callback){
            final /* synthetic */ UTSCallback $callback;
            {
                this.$callback = $callback;
                super(0);
            }

            public final void invoke() {
                block0: {
                    UTSCallback uTSCallback = this.$callback;
                    if (uTSCallback == null) break block0;
                    uTSCallback.invoke(new Object[0]);
                }
            }
        }));
    }

    public static final void connectWifiByJs(@NotNull WifiConnectOptionJSONObject option) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        IndexKt.connectWifi(new WifiConnectOption(option.getSSID(), option.getBSSID(), option.getPassword(), option.getMaunal(), option.getPartialInfo(), (Function1<? super UniWifiResult, Unit>)((Function1)new Function1<UniWifiResult, Unit>(option){
            final /* synthetic */ WifiConnectOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniWifiResult res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)res), (String)"res");
                    UTSCallback uTSCallback = this.$option.getSuccess();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<? super UniError, Unit>)((Function1)new Function1<UniError, Unit>(option){
            final /* synthetic */ WifiConnectOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniError res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getFail();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(option){
            final /* synthetic */ WifiConnectOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull Object res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getComplete();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        })));
    }

    public static final void stopWifiByJs(@NotNull WifiOptionJSONObject option) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        IndexKt.stopWifi(new WifiOption((Function1<? super UniWifiResult, Unit>)((Function1)new Function1<UniWifiResult, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniWifiResult res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)res), (String)"res");
                    UTSCallback uTSCallback = this.$option.getSuccess();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<? super UniError, Unit>)((Function1)new Function1<UniError, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniError res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getFail();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(option){
            final /* synthetic */ WifiOptionJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull Object res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getComplete();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        })));
    }

    public static final void getConnectedWifiByJs(@NotNull GetConnectedWifiOptionsJSONObject option) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        IndexKt.getConnectedWifi(new GetConnectedWifiOptions(option.getPartialInfo(), (Function1<? super UniWifiResult, Unit>)((Function1)new Function1<UniWifiResult, Unit>(option){
            final /* synthetic */ GetConnectedWifiOptionsJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniWifiResult res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)res), (String)"res");
                    UTSCallback uTSCallback = this.$option.getSuccess();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<? super UniError, Unit>)((Function1)new Function1<UniError, Unit>(option){
            final /* synthetic */ GetConnectedWifiOptionsJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull UniError res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getFail();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        }), (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(option){
            final /* synthetic */ GetConnectedWifiOptionsJSONObject $option;
            {
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull Object res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                    UTSCallback uTSCallback = this.$option.getComplete();
                    if (uTSCallback == null) break block0;
                    Object[] objectArray = new Object[]{res};
                    uTSCallback.invoke(objectArray);
                }
            }
        })));
    }

    static {
        Object[] objectArray = new UTSArray[7];
        Object[] objectArray2 = new Object[]{12000, "not init."};
        objectArray[0] = UTSArrayKt.utsArrayOf((Object[])objectArray2);
        objectArray2 = new Object[]{12001, "system not support"};
        objectArray[1] = UTSArrayKt.utsArrayOf((Object[])objectArray2);
        objectArray2 = new Object[]{12002, "password error Wi-Fi"};
        objectArray[2] = UTSArrayKt.utsArrayOf((Object[])objectArray2);
        objectArray2 = new Object[]{12005, "wifi not turned on"};
        objectArray[3] = UTSArrayKt.utsArrayOf((Object[])objectArray2);
        objectArray2 = new Object[]{12007, "user denied"};
        objectArray[4] = UTSArrayKt.utsArrayOf((Object[])objectArray2);
        objectArray2 = new Object[]{12010, "unknown error"};
        objectArray[5] = UTSArrayKt.utsArrayOf((Object[])objectArray2);
        objectArray2 = new Object[]{12013, "wifi config may be expired"};
        objectArray[6] = UTSArrayKt.utsArrayOf((Object[])objectArray2);
        WifiUniErrors = new Map(UTSArrayKt.utsArrayOf((Object[])objectArray));
    }
}

