import { minify } from 'terser';

function terser(options) {
    return {
        name: 'terser',
        async renderChunk(code, chunk, outputOptions) {
            const defaultOptions = {
                sourceMap: outputOptions.sourcemap === true || typeof outputOptions.sourcemap === 'string'
            };
            if (outputOptions.format === 'es') {
                defaultOptions.module = true;
            }
            if (outputOptions.format === 'cjs') {
                defaultOptions.toplevel = true;
            }
            return minify(code, { ...defaultOptions, ...(options || {}) });
        }
    };
}

export { terser as default };
//# sourceMappingURL=index.js.map
