if (typeof Promise !== "undefined" && !Promise.prototype.finally) {
  Promise.prototype.finally = function(callback) {
    const promise = this.constructor;
    return this.then(
      (value) => promise.resolve(callback()).then(() => value),
      (reason) => promise.resolve(callback()).then(() => {
        throw reason;
      })
    );
  };
}
;
if (typeof uni !== "undefined" && uni && uni.requireGlobal) {
  const global = uni.requireGlobal();
  ArrayBuffer = global.ArrayBuffer;
  Int8Array = global.Int8Array;
  Uint8Array = global.Uint8Array;
  Uint8ClampedArray = global.Uint8ClampedArray;
  Int16Array = global.Int16Array;
  Uint16Array = global.Uint16Array;
  Int32Array = global.Int32Array;
  Uint32Array = global.Uint32Array;
  Float32Array = global.Float32Array;
  Float64Array = global.Float64Array;
  BigInt64Array = global.BigInt64Array;
  BigUint64Array = global.BigUint64Array;
}
;
if (uni.restoreGlobal) {
  uni.restoreGlobal(Vue, weex, plus, setTimeout, clearTimeout, setInterval, clearInterval);
}
(function(vue) {
  "use strict";
  function formatAppLog(type, filename, ...args) {
    if (uni.__log__) {
      uni.__log__(type, filename, ...args);
    } else {
      console[type].apply(console, [...args, filename]);
    }
  }
  const { registerUTSInterface, initUTSProxyClass, initUTSProxyFunction, initUTSPackageName, initUTSIndexClassName, initUTSClassName } = uni;
  const name = "uniWifi";
  const moduleName = "uni-wifi";
  const moduleType = "";
  const errMsg = ``;
  const is_uni_modules = true;
  const pkg = /* @__PURE__ */ initUTSPackageName(name, is_uni_modules);
  const cls = /* @__PURE__ */ initUTSIndexClassName(name, is_uni_modules);
  const startWifi = /* @__PURE__ */ initUTSProxyFunction(false, { moduleName, moduleType, errMsg, main: true, package: pkg, class: cls, name: "startWifiByJs", keepAlive: false, params: [{ "name": "option", "type": "UTSSDKModulesUniWifiStartWifiOptionsJSONObject" }], return: "" });
  const stopWifi = /* @__PURE__ */ initUTSProxyFunction(false, { moduleName, moduleType, errMsg, main: true, package: pkg, class: cls, name: "stopWifiByJs", keepAlive: false, params: [{ "name": "option", "type": "UTSSDKModulesUniWifiStopWifiOptionsJSONObject" }], return: "" });
  const getWifiList = /* @__PURE__ */ initUTSProxyFunction(false, { moduleName, moduleType, errMsg, main: true, package: pkg, class: cls, name: "getWifiListByJs", keepAlive: false, params: [{ "name": "option", "type": "UTSSDKModulesUniWifiGetWifiListOptionsJSONObject" }], return: "" });
  const onGetWifiList = /* @__PURE__ */ initUTSProxyFunction(false, { moduleName, moduleType, errMsg, main: true, package: pkg, class: cls, name: "onGetWifiListByJs", keepAlive: false, params: [{ "name": "callback", "type": "UTSCallback" }], return: "" });
  const offGetWifiList = /* @__PURE__ */ initUTSProxyFunction(false, { moduleName, moduleType, errMsg, main: true, package: pkg, class: cls, name: "offGetWifiListByJs", keepAlive: false, params: [{ "name": "callback", "type": "UTSCallback" }], return: "" });
  const e = "https://api.newayz.com", t = "/location/hub/v1/track_points", o = "https://api.newayz.com/positioning/ip/v1/ips";
  let s = { interval: 5e3, isLocateOnce: true, deviceId: "", trakUrl: "" }, n = [], i = "start";
  const c = (e2) => {
    formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "wifi数据变化", e2.wifiList.length), n = g(e2.wifiList);
  }, a = (e2, t2) => ({ success: (t3) => {
    formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "操作wifi成功", "start" === i), "start" === i && onGetWifiList(c), e2(t3);
  }, fail: (e3) => {
    formatAppLog("error", "at utils/wz_sdk_uniapp.js:1", "操作wifi失败", e3), t2(new Error(e3));
  } });
  function r() {
    offGetWifiList(c);
  }
  function l() {
    return i = "stop", new Promise((e2, t2) => {
      stopWifi(a(e2, t2));
    });
  }
  const u = () => new Promise((e2, t2) => {
    i = "start", startWifi(a(e2, t2));
  }), d = () => new Promise((e2, t2) => {
    getWifiList({ success: (t3) => {
      formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "扫描 WIFI 成功", t3), onGetWifiList(c), e2(t3);
    }, fail: (e3) => {
      formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "扫描 WIFI 失败", e3), t2(e3);
    } });
  }), g = (e2) => {
    if (formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "list 类型 formatWifi："), formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "list 类型：", Object.prototype.toString.call(e2)), !Array.isArray(e2))
      return void formatAppLog("error", "at utils/wz_sdk_uniapp.js:1", "错误：formatWifi 接收的 list 不是数组！");
    formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "===============================");
    return e2.map((e3) => {
      const { signalStrength: t2 } = e3;
      return e3.signalStrength = parseInt(100 - t2 / 2), e3.macAddress = e3.BSSID, e3.ssid = e3.SSID, e3.frequency = e3.frequency, e3;
    });
  };
  var p = Object.freeze({ __proto__: null, firstStartWifi: u, scanWifi: d, stopScanWifi: r, stoWifi: l, get scanWifiList() {
    return n;
  } });
  let f = { asset: { id: "" }, location: { gnss: {}, wifis: [], bluetooths: [], position: {} }, product: { name: "uni_program", version: "v1.0.0" }, id: y }, m = { asset: { id: "" }, location: { timestamp: 0, position: { point: {} } }, id: y };
  function y() {
    let e2 = 0;
    return (/* @__PURE__ */ new Date()).getTime(), window.performance && "function" == typeof window.performance.now && (e2 += performance.now()), "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(t2) {
      var o2 = (e2 + 16 * Math.random()) % 16 | 0;
      return e2 = Math.floor(e2 / 16), ("x" == t2 ? o2 : 3 & o2 | 8).toString(16);
    });
  }
  let w, x = "", v = {}, I = false, h = null, L = false, S = false, _ = { timestamp: 0, longitude: 0, latitude: 0, speed: 0, accuracy: 0, source: "", address: "" }, W = { source: "", timestamp: 0, longitude: 0, latitude: 0, accuracy: 0, spatialReference: "", address: "", place: {} }, O = { timestamp: 0, point: { longitude: 0, latitude: 0 }, accuracy: 0 }, C = true;
  function P(e2, t2, o2, n2) {
    x = e2, v = s, v.deviceId = t2, v.isLocateOnce = o2, n2 > v.interval && (v.interval = n2);
  }
  function T(o2, s2) {
    try {
      const i2 = uni.getSystemInfoSync(), c2 = i2.osName;
      I = "android" === c2;
      i2.osVersion, i2.deviceType;
      const a2 = i2.uniPlatform;
      if ("app" === a2 || "mp-weixin" === a2) {
        if (function(e2) {
          const t2 = uni.getSystemSetting();
          formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "systemSetting：", t2);
          const o3 = t2.locationEnabled;
          if (t2.wifiEnabled, !o3)
            return e2({ code: 1001, msg: "定位权限未开" }), false;
          if (!x)
            return e2({ code: 1003, msg: "您尚未配置 appKey" }), false;
          if (!v)
            return e2({ code: 1004, msg: "option 参数未配置" }), false;
          if (!v.deviceId)
            return e2({ code: 1005, msg: "option 参数非法, 需提供设备 ID " }), false;
          return true;
        }(s2)) {
          const i3 = e + t + "?access_key=" + x;
          formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "getLocation：", I, i3), I ? (f.asset.id = v.deviceId, u().then((i4) => {
            S = true, formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "getLocation：", "准备请求--->"), function(o3, s3) {
              v.isLocateOnce ? (formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "startInterval ： "), w = setInterval(() => {
                formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "This runs every 1 second");
              }, 1e3), setTimeout(function() {
                return function(o4, s4) {
                  clearInterval(w);
                  const i5 = n;
                  if (formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "stopInterval isScanning ", C), C) {
                    const n2 = e + t + "?access_key=" + x;
                    i5 && i5.length >= 0 ? (f.location.wifis = i5, f.location.gnss = O, F(n2, f, o4, s4)) : s4({ code: 10010, msg: "定位服务返回失败" }), r();
                  }
                }(o3, s3);
              }, 5e3), E(o3, s3)) : (z(), E(o3, s3), h = setInterval(() => {
                E(o3, s3);
              }, v.interval));
            }(o2, s2);
          }, (e2) => {
            b(o2, s2);
          })) : b(o2, s2);
        }
      } else
        formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "uniPlatForm：", a2), S = false, b(o2, s2);
    } catch (e2) {
      s2({ code: 2001, msg: e2 });
    }
  }
  function k(t2, o2, s2 = 1, n2 = 20) {
    return new Promise((i2, c2) => {
      if (!x)
        return void c2({ code: 1003, msg: "您尚未配置 appKey" });
      G(e + "/location/scenario/v1/placesearch?access_key=" + x + "&name=" + t2 + "&city=" + o2 + "&page_index=" + s2 + "&page_size=" + n2, i2, c2);
    });
  }
  function q(t2, o2, s2, n2 = 5e3, i2 = "distance_score", c2 = 1, a2 = 20) {
    return new Promise((r2, l2) => {
      if (!x)
        return void l2({ code: 1003, msg: "您尚未配置 appKey" });
      if (!s2)
        return l2({ code: 1008, msg: "请先获取定位" });
      if (!t2)
        return l2({ code: 1009, msg: "请填写搜索关键词" });
      G(e + "/location/scenario/v1/nearbysearch?access_key=" + x + "&keywords=" + t2 + "&category=" + o2 + "&location=" + s2 + "&radius=" + n2 + "&orderby=" + i2 + "&page_index=" + c2 + "&page_size=" + a2, r2, l2);
    });
  }
  function R(t2, o2) {
    return new Promise((s2, n2) => {
      if (!x)
        return void n2({ code: 1003, msg: "您尚未配置 appKey" });
      G(e + "/location/scenario/v1/geocode?access_key=" + x + "&address=" + t2 + "&city=" + o2, s2, n2);
    });
  }
  function D(o2, s2, n2) {
    return new Promise((i2, c2) => {
      if (!x)
        return void c2({ code: 1003, msg: "您尚未配置 appKey" });
      const a2 = e + t + "?access_key=" + x;
      var r2, l2, u2, d2;
      _ = { latitude: s2, longitude: o2, source: "", speed: 0, accuracy: 30, altitude: 0, spatialReference: n2, timestamp: (/* @__PURE__ */ new Date()).getTime() }, J(), r2 = a2, l2 = m, u2 = i2, d2 = c2, formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "requestReverseBody ： ", l2), uni.request({ url: r2, method: "POST", data: l2, success: (e2) => {
        formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "request success ： " + JSON.stringify(e2));
        const t2 = e2.data;
        200 == e2.statusCode && null != t2 && null != t2.location && null != t2.location.address ? (W = N(t2), u2(W)) : d2({ code: e2.statusCode, msg: "定位服务返回失败" });
      }, fail: (e2) => {
        formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", e2), d2({ code: 10010, msg: "定位返回失败：" + e2 });
      } });
    });
  }
  function b(s2, n2) {
    const i2 = e + t + "?access_key=" + x;
    L = true, v.isLocateOnce ? uni.getLocation({ type: "wgs84", isHighAccuracy: true, success: (e2) => {
      formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "当前位置的经度：" + e2.longitude), formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "当前位置的纬度：" + e2.latitude), _ = { latitude: e2.latitude, longitude: e2.longitude, source: "", speed: e2.speed, accuracy: e2.accuracy, altitude: e2.altitude, spatialReference: "wgs84", timestamp: (/* @__PURE__ */ new Date()).getTime() }, J(), F(i2, m, s2, n2);
    }, fail: (e2) => {
      formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "err：" + JSON.stringify(e2)), function(e3, t2) {
        const s3 = o + "?access_key=" + x;
        formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "getIPLocation"), uni.request({ url: s3, method: "GET", success: (o2) => {
          formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "request success ： ", o2);
          const s4 = o2.data || {};
          if (200 === o2.statusCode && s4 && s4.location) {
            const t3 = s4.location;
            if (t3.address && t3.address.name)
              return W = A(s4), void e3(W);
          }
          const n3 = 200 === o2.statusCode ? "定位服务返回成功，但地址数据不完整" : `定位服务返回失败，状态码：${o2.statusCode}`, i3 = { code: o2.statusCode || 10011, msg: n3 };
          t2(i3);
        }, fail: (e4) => {
          formatAppLog("error", "at utils/wz_sdk_uniapp.js:1", "IP定位请求接口失败：", e4);
          const o2 = { code: 10011, msg: "定位返回失败：" + (e4.errMsg || JSON.stringify(e4)) };
          t2(o2);
        }, complete: () => {
          formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "定位请求完成");
        } });
      }(s2, n2);
    }, complete: (e2) => {
    } }) : uni.startLocationUpdate({ type: "wgs84", success: (e2) => {
      uni.onLocationChange((e3) => {
        const { latitude: t2, longitude: o2, speed: c2, accuracy: a2, altitude: r2 } = e3;
        t2 && o2 && 0 !== t2 && 0 !== o2 ? (_ = { latitude: e3.latitude, longitude: e3.longitude, source: "", speed: e3.speed, accuracy: e3.accuracy, altitude: e3.altitude, spatialReference: "wgs84", timestamp: (/* @__PURE__ */ new Date()).getTime() }, J(), F(i2, m, s2, n2)) : n2({ code: 10015, msg: "【定位异常】经纬度为空或无效值" });
      });
    }, fail: (e2) => {
      n2({ code: 10011, msg: e2.errMsg });
    }, complete: (e2) => {
    } });
  }
  function z() {
    L = true, uni.startLocationUpdate({ type: "wgs84", success: (e2) => {
      uni.onLocationChange((e3) => {
        O = { timestamp: (/* @__PURE__ */ new Date()).getTime(), point: { longitude: e3.longitude, latitude: e3.latitude }, accuracy: e3.accuracy };
      });
    }, fail: (e2) => {
      error({ code: 10011, msg: e2.errMsg });
    }, complete: (e2) => {
    } });
  }
  function E(o2, s2) {
    const i2 = e + t + "?access_key=" + x;
    formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "开始扫描 WIFI ： "), C = true, d().then((e2) => {
      formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "扫描 WIFI成功回调 ： "), w && clearInterval(w), C = false;
      const t2 = n;
      0 === t2.length && v.isLocateOnce ? b(o2, s2) : (f.location.wifis = t2, f.location.gnss = O, F(i2, f, o2, s2));
    }, (e2) => {
      C = false, r(), b(o2, s2);
    });
  }
  function F(e2, t2, o2, s2) {
    formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "requestBody ： ", t2), uni.request({ url: e2, method: "POST", data: t2, success: (e3) => {
      formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "request success ： " + JSON.stringify(e3));
      const t3 = e3.data;
      200 == e3.statusCode && null != t3 && null != t3.location && null != t3.location.address ? (W = N(t3), v.isLocateOnce && K(), o2(W)) : s2({ code: e3.statusCode, msg: "定位服务返回失败" });
    }, fail: (e3) => {
      formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", e3), s2({ code: 10010, msg: "定位返回失败：" + e3 });
    } });
  }
  function G(e2, t2, o2) {
    formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "request:", e2), uni.request({ url: e2, method: "GET", success: (e3) => {
      const s2 = e3.data;
      200 != e3.statusCode || null == s2 ? o2({ code: e3.statusCode, msg: "请求异常" }) : t2(s2);
    }, fail: (e3) => {
      formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", e3), o2({ code: 10010, msg: "定位返回失败：" + e3 });
    } });
  }
  function K() {
    formatAppLog("log", "at utils/wz_sdk_uniapp.js:1", "stopLocation"), L && !v.isLocateOnce && (L = false, uni.stopLocationUpdate(), uni.offLocationChange(function(e2) {
    })), null != p && S && l(), h && (clearInterval(h), h = null);
  }
  function M(e2) {
    x = e2;
  }
  const N = (e2) => {
    const { address: t2, place: o2, position: { source: s2, accuracy: n2, spatialReference: i2, timestamp: c2, point: { longitude: a2, latitude: r2 } } } = e2.location;
    return { source: s2, timestamp: c2, longitude: a2, latitude: r2, accuracy: n2, spatialReference: i2, address: t2, place: o2 };
  }, A = (e2) => {
    const { location: { address: t2, place: o2 = "", position: { source: s2 = "", accuracy: n2 = 0, spatialReference: i2 = "", timestamp: c2 = (/* @__PURE__ */ new Date()).getTime(), point: { longitude: a2, latitude: r2 } } } } = e2;
    return { source: s2, timestamp: c2, longitude: a2, latitude: r2, accuracy: n2, spatialReference: i2, address: t2, place: o2 };
  };
  function J() {
    const { source: e2, timestamp: t2, longitude: o2, latitude: s2, accuracy: n2, spatialReference: i2 } = _;
    m.location.position = { point: { longitude: o2, latitude: s2 }, source: e2, timestamp: t2, accuracy: n2, spatialReference: i2 };
  }
  const _export_sfc = (sfc, props) => {
    const target = sfc.__vccOpts || sfc;
    for (const [key, val] of props) {
      target[key] = val;
    }
    return target;
  };
  const _sfc_main$2 = {
    data() {
      return {
        title: "Hello",
        wzLocation: {
          accuracy: 0,
          address: {
            name: ""
          },
          place: {
            name: ""
          },
          latitude: 0,
          longitude: 0,
          source: "",
          spatialReference: "",
          timestamp: ""
        },
        map: null
        // 保存地图实例
      };
    },
    mounted() {
      this.initMap();
    },
    onLoad() {
    },
    methods: {
      initMap() {
        const init = () => {
          if (!window.aimap) {
            formatAppLog("warn", "at pages/index/index.vue:73", "aimap SDK 未加载，重试中...");
            setTimeout(init, 300);
            return;
          }
          try {
            window.aimap.accessToken = "";
            window.aimap.baseApiUrl = "https://location-dev.newayz.com";
            this.map = new window.aimap.Map({
              container: "app",
              center: [121.50547, 31.236532],
              zoom: 13,
              pitch: 0,
              bearing: 0,
              style: "aimap://styles/aimap/white-21Q4-v1"
            });
          } catch (e2) {
            formatAppLog("error", "at pages/index/index.vue:91", "地图初始化失败：", e2);
          }
        };
        init();
      },
      singleClick() {
        const deviceInfo = uni.getDeviceInfo();
        formatAppLog("log", "at pages/index/index.vue:99", "deviceId：", deviceInfo.deviceId);
        P("", deviceInfo.deviceId, true, 0);
        T(
          (res) => {
            formatAppLog("log", "at pages/index/index.vue:103", "index success", res);
            res.timestamp = new Date(res.timestamp).toLocaleString();
            this.wzLocation = res;
            if (this.wzLocation && this.map) {
              new aimap.Marker().setLngLat([this.wzLocation.longitude, this.wzLocation.latitude]).addTo(this.map);
              this.map.flyTo({
                center: [this.wzLocation.longitude, this.wzLocation.latitude],
                zoom: 13,
                speed: 1,
                curve: 2,
                easing(t2) {
                  return t2;
                }
              });
            }
          },
          (fail) => {
            formatAppLog("log", "at pages/index/index.vue:124", "fail" + fail.code + fail.msg);
          }
        );
      },
      conitueClick() {
        const deviceInfo = uni.getDeviceInfo();
        formatAppLog("log", "at pages/index/index.vue:130", "deviceId：", deviceInfo.deviceId);
        P("", deviceInfo.deviceId, false, 5e3);
        T(
          (res) => {
            formatAppLog("log", "at pages/index/index.vue:134", "index success", res);
            res.timestamp = new Date(res.timestamp).toLocaleString();
            this.wzLocation = res;
            if (this.wzLocation && this.map) {
              new aimap.Marker().setLngLat([this.wzLocation.longitude, this.wzLocation.latitude]).addTo(this.map);
              this.map.flyTo({
                center: [this.wzLocation.longitude, this.wzLocation.latitude],
                zoom: 13,
                speed: 1,
                curve: 2,
                easing(t2) {
                  return t2;
                }
              });
            }
          },
          (fail) => {
            formatAppLog("log", "at pages/index/index.vue:155", "fail" + fail.code + fail.msg);
          }
        );
      },
      getAddress() {
        M("");
        D(107.191693, 27.945061, "wgs84").then(
          (res) => {
            formatAppLog("log", "at pages/index/index.vue:163", "address : " + res.address.name);
          },
          (error2) => {
            formatAppLog("log", "at pages/index/index.vue:166", "error : " + error2);
          }
        );
      },
      getGeoCode() {
        M("");
        R("旺座", "西安市").then(
          (res) => {
            let dataList = res;
            formatAppLog("log", "at pages/index/index.vue:175", dataList[0].geoPoint, dataList[0].address.name);
          },
          (error2) => {
            formatAppLog("log", "at pages/index/index.vue:178", "error : ", error2);
          }
        );
      },
      poiSearch() {
        M("");
        k("泛悦城T2", "武汉市", 2, 20).then(
          (res) => {
            let dataList = res;
            formatAppLog("log", "at pages/index/index.vue:187", "poi搜索：", dataList);
            formatAppLog("log", "at pages/index/index.vue:188", "poi搜索：", dataList[0].geoPoint, dataList[0].address.name);
          },
          (error2) => {
            formatAppLog("log", "at pages/index/index.vue:191", "error : ", error2);
          }
        );
      },
      poiNearBySearch() {
        M("");
        q("乒乓球", "体育场馆", "120.59986,31.25979").then(
          (res) => {
            let dataList = res;
            formatAppLog("log", "at pages/index/index.vue:201", "poi搜索：", dataList[0].geoPoint, dataList[0].address.name);
          },
          (error2) => {
            formatAppLog("log", "at pages/index/index.vue:204", "error : ", error2);
          }
        );
      },
      stopLocation() {
        K();
      }
    }
  };
  function _sfc_render$1(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("view", { class: "content" }, [
      vue.createElementVNode("view", {
        id: "map",
        class: "map-container"
      }),
      vue.createElementVNode("view", { class: "float-content" }, [
        $data.wzLocation ? (vue.openBlock(), vue.createElementBlock("view", {
          key: 0,
          class: "location-info"
        }, [
          vue.createElementVNode(
            "view",
            { class: "name" },
            vue.toDisplayString($data.wzLocation.address.name),
            1
            /* TEXT */
          ),
          vue.createElementVNode(
            "view",
            { class: "name" },
            vue.toDisplayString($data.wzLocation.place.name),
            1
            /* TEXT */
          ),
          vue.createElementVNode(
            "view",
            { class: "sub" },
            vue.toDisplayString($data.wzLocation.longitude) + " , " + vue.toDisplayString($data.wzLocation.latitude),
            1
            /* TEXT */
          ),
          vue.createElementVNode(
            "view",
            { class: "time" },
            vue.toDisplayString($data.wzLocation.timestamp),
            1
            /* TEXT */
          )
        ])) : vue.createCommentVNode("v-if", true),
        vue.createElementVNode("view", { class: "btn-group" }, [
          vue.createElementVNode("button", {
            onClick: _cache[0] || (_cache[0] = (...args) => $options.singleClick && $options.singleClick(...args)),
            class: "map-btn"
          }, "单次定位"),
          vue.createElementVNode("button", {
            onClick: _cache[1] || (_cache[1] = (...args) => $options.conitueClick && $options.conitueClick(...args)),
            class: "map-btn"
          }, "连续定位"),
          vue.createElementVNode("button", {
            onClick: _cache[2] || (_cache[2] = (...args) => $options.stopLocation && $options.stopLocation(...args)),
            class: "map-btn"
          }, "停止定位"),
          vue.createElementVNode("button", {
            onClick: _cache[3] || (_cache[3] = (...args) => $options.getAddress && $options.getAddress(...args)),
            class: "map-btn"
          }, "获取地址"),
          vue.createElementVNode("button", {
            onClick: _cache[4] || (_cache[4] = (...args) => $options.getGeoCode && $options.getGeoCode(...args)),
            class: "map-btn"
          }, "正地理"),
          vue.createElementVNode("button", {
            onClick: _cache[5] || (_cache[5] = (...args) => $options.poiSearch && $options.poiSearch(...args)),
            class: "map-btn"
          }, "poi 搜索"),
          vue.createElementVNode("button", {
            onClick: _cache[6] || (_cache[6] = (...args) => $options.poiNearBySearch && $options.poiNearBySearch(...args)),
            class: "map-btn"
          }, "poi 附近搜索")
        ])
      ])
    ]);
  }
  const PagesIndexIndex = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["render", _sfc_render$1], ["__file", "D:/wz_code/uni-sdk-new/uni-app-blank/pages/index/index.vue"]]);
  const _sfc_main$1 = {};
  function _sfc_render(_ctx, _cache) {
    return vue.openBlock(), vue.createElementBlock("view");
  }
  const PagesIndexLocationLocation = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["render", _sfc_render], ["__file", "D:/wz_code/uni-sdk-new/uni-app-blank/pages/index/location/location.vue"]]);
  __definePage("pages/index/index", PagesIndexIndex);
  __definePage("pages/index/location/location", PagesIndexLocationLocation);
  const _sfc_main = {
    onLaunch: function() {
      formatAppLog("log", "at App.vue:4", "App Launch");
    },
    onShow: function() {
      formatAppLog("log", "at App.vue:7", "App Show");
    },
    onHide: function() {
      formatAppLog("log", "at App.vue:10", "App Hide");
    }
  };
  const App = /* @__PURE__ */ _export_sfc(_sfc_main, [["__file", "D:/wz_code/uni-sdk-new/uni-app-blank/App.vue"]]);
  function createApp() {
    const app = vue.createVueApp(App);
    return {
      app
    };
  }
  const { app: __app__, Vuex: __Vuex__, Pinia: __Pinia__ } = createApp();
  uni.Vuex = __Vuex__;
  uni.Pinia = __Pinia__;
  __app__.provide("__globalStyles", __uniConfig.styles);
  __app__._component.mpType = "app";
  __app__._component.render = () => {
  };
  __app__.mount("#app");
})(Vue);
