"use strict";
const common_vendor = require("../../common/vendor.js");
const utils_wz_location = require("../../utils/wz_location.js");
const _sfc_main = {
  data() {
    return {
      title: "Hello",
      wzLocation: {
        accuracy: 0,
        address: {
          name: ""
        },
        place: {
          name: ""
        },
        latitude: 0,
        longitude: 0,
        source: "",
        spatialReference: "",
        timestamp: ""
      },
      map: null
      // 保存地图实例
    };
  },
  mounted() {
    this.initMap();
  },
  onLoad() {
  },
  methods: {
    initMap() {
      const init = () => {
        if (!window.aimap) {
          common_vendor.index.__f__("warn", "at pages/index/index.vue:73", "aimap SDK 未加载，重试中...");
          setTimeout(init, 300);
          return;
        }
        try {
          window.aimap.accessToken = "5hlKj1icxbxXCoLZ1QwWmO2OyGOjhmCC";
          window.aimap.baseApiUrl = "https://location-dev.newayz.com";
          this.map = new window.aimap.Map({
            container: "app",
            center: [121.50547, 31.236532],
            zoom: 13,
            pitch: 0,
            bearing: 0,
            style: "aimap://styles/aimap/white-21Q4-v1"
          });
        } catch (e) {
          common_vendor.index.__f__("error", "at pages/index/index.vue:91", "地图初始化失败：", e);
        }
      };
      init();
    },
    singleClick() {
      const deviceInfo = common_vendor.index.getDeviceInfo();
      common_vendor.index.__f__("log", "at pages/index/index.vue:99", "deviceId：", deviceInfo.deviceId);
      utils_wz_location.initOption("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn", deviceInfo.deviceId, true, 0);
      utils_wz_location.getLocation(
        (res) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:103", "index success", res);
          res.timestamp = new Date(res.timestamp).toLocaleString();
          this.wzLocation = res;
        },
        (fail) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:108", "fail" + fail.code + fail.msg);
        }
      );
    },
    conitueClick() {
      const deviceInfo = common_vendor.index.getDeviceInfo();
      common_vendor.index.__f__("log", "at pages/index/index.vue:114", "deviceId：", deviceInfo.deviceId);
      utils_wz_location.initOption("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn", deviceInfo.deviceId, false, 5e3);
      utils_wz_location.getLocation(
        (res) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:118", "index success", res);
          res.timestamp = new Date(res.timestamp).toLocaleString();
          this.wzLocation = res;
        },
        (fail) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:123", "fail" + fail.code + fail.msg);
        }
      );
    },
    getAddress() {
      utils_wz_location.setAk("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn");
      utils_wz_location.getReverseCode(107.191693, 27.945061, "wgs84").then(
        (res) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:131", "address : " + res.address.name);
        },
        (error) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:134", "error : " + error);
        }
      );
    },
    getGeoCode() {
      utils_wz_location.setAk("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn");
      utils_wz_location.getGeoCode("旺座", "西安市").then(
        (res) => {
          let dataList = res;
          common_vendor.index.__f__("log", "at pages/index/index.vue:143", dataList[0].geoPoint, dataList[0].address.name);
        },
        (error) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:146", "error : ", error);
        }
      );
    },
    poiSearch() {
      utils_wz_location.setAk("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn");
      utils_wz_location.poiSearch("泛悦城T2", "武汉市", 2, 20).then(
        (res) => {
          let dataList = res;
          common_vendor.index.__f__("log", "at pages/index/index.vue:155", "poi搜索：", dataList);
          common_vendor.index.__f__("log", "at pages/index/index.vue:156", "poi搜索：", dataList[0].geoPoint, dataList[0].address.name);
        },
        (error) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:159", "error : ", error);
        }
      );
    },
    poiNearBySearch() {
      utils_wz_location.setAk("E9IprXW39vsYDLfqnXCo3FN7AWojSHdn");
      utils_wz_location.poiNearbySearch("乒乓球", "体育场馆", "120.59986,31.25979").then(
        (res) => {
          let dataList = res;
          common_vendor.index.__f__("log", "at pages/index/index.vue:169", "poi搜索：", dataList[0].geoPoint, dataList[0].address.name);
        },
        (error) => {
          common_vendor.index.__f__("log", "at pages/index/index.vue:172", "error : ", error);
        }
      );
    },
    stopLocation() {
      utils_wz_location.stopLocation();
    }
  }
};
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  return common_vendor.e({
    a: $data.wzLocation
  }, $data.wzLocation ? {
    b: common_vendor.t($data.wzLocation.address.name),
    c: common_vendor.t($data.wzLocation.place.name),
    d: common_vendor.t($data.wzLocation.longitude),
    e: common_vendor.t($data.wzLocation.latitude),
    f: common_vendor.t($data.wzLocation.timestamp)
  } : {}, {
    g: common_vendor.o((...args) => $options.singleClick && $options.singleClick(...args)),
    h: common_vendor.o((...args) => $options.conitueClick && $options.conitueClick(...args)),
    i: common_vendor.o((...args) => $options.stopLocation && $options.stopLocation(...args)),
    j: common_vendor.o((...args) => $options.getAddress && $options.getAddress(...args)),
    k: common_vendor.o((...args) => $options.getGeoCode && $options.getGeoCode(...args)),
    l: common_vendor.o((...args) => $options.poiSearch && $options.poiSearch(...args)),
    m: common_vendor.o((...args) => $options.poiNearBySearch && $options.poiNearBySearch(...args))
  });
}
const MiniProgramPage = /* @__PURE__ */ common_vendor._export_sfc(_sfc_main, [["render", _sfc_render]]);
wx.createPage(MiniProgramPage);
//# sourceMappingURL=../../../.sourcemap/mp-weixin/pages/index/index.js.map
