"use strict";
const common_vendor = require("../common/vendor.js");
exports.scanWifiList = [];
let type = "start";
const _WifiChange = (res) => {
  common_vendor.index.__f__("log", "at utils/wz_wifi.js:5", "wifi数据变化", res.wifiList.length);
  exports.scanWifiList = formatWifi(res.wifiList);
};
const wifiCallback = (resolve, reject) => {
  return {
    success: (res) => {
      common_vendor.index.__f__("log", "at utils/wz_wifi.js:12", "操作wifi成功", type === "start");
      if (type === "start") {
        common_vendor.index.onGetWifiList(_WifiChange);
      }
      resolve(res);
    },
    fail: (err) => {
      common_vendor.index.__f__("error", "at utils/wz_wifi.js:19", "操作wifi失败", err);
      reject(new Error(err));
    }
  };
};
function stopScanWifi() {
  common_vendor.index.offGetWifiList(_WifiChange);
}
function stoWifi() {
  type = "stop";
  return new Promise((resolve, reject) => {
    common_vendor.index.stopWifi(wifiCallback(resolve, reject));
  });
}
const firstStartWifi = () => {
  return new Promise((resolve, reject) => {
    type = "start";
    common_vendor.index.startWifi(wifiCallback(resolve, reject));
  });
};
const scanWifi = () => {
  return new Promise((resolve, reject) => {
    common_vendor.index.getWifiList({
      success: (res) => {
        common_vendor.index.__f__("log", "at utils/wz_wifi.js:61", "扫描 WIFI 成功", res);
        common_vendor.index.onGetWifiList(_WifiChange);
        resolve(res);
      },
      fail: (err) => {
        common_vendor.index.__f__("log", "at utils/wz_wifi.js:66", "扫描 WIFI 失败", err);
        reject(err);
      }
    });
  });
};
const formatWifi = (list) => {
  common_vendor.index.__f__("log", "at utils/wz_wifi.js:75", "list 类型 formatWifi：");
  common_vendor.index.__f__("log", "at utils/wz_wifi.js:76", "list 类型：", Object.prototype.toString.call(list));
  if (!Array.isArray(list)) {
    common_vendor.index.__f__("error", "at utils/wz_wifi.js:78", "错误：formatWifi 接收的 list 不是数组！");
    return;
  }
  common_vendor.index.__f__("log", "at utils/wz_wifi.js:81", "===============================");
  const res = list.map((item) => {
    const {
      signalStrength
    } = item;
    item.signalStrength = parseInt(100 - signalStrength / 2);
    item.macAddress = item.BSSID;
    item.ssid = item.SSID;
    item.frequency = item.frequency;
    return item;
  });
  return res;
};
const wifiManager = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  firstStartWifi,
  scanWifi,
  get scanWifiList() {
    return exports.scanWifiList;
  },
  stoWifi,
  stopScanWifi
}, Symbol.toStringTag, { value: "Module" }));
exports.firstStartWifi = firstStartWifi;
exports.scanWifi = scanWifi;
exports.stoWifi = stoWifi;
exports.stopScanWifi = stopScanWifi;
exports.wifiManager = wifiManager;
//# sourceMappingURL=../../.sourcemap/mp-weixin/utils/wz_wifi.js.map
