/*
 * Decompiled with CFR 0.152.
 */
package com.wayz.location.toolkit.model;

import android.text.TextUtils;
import com.wayz.location.toolkit.model.MakeJSONObject;
import com.wayz.location.toolkit.model.b;
import com.wayz.location.toolkit.model.z;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class a
implements MakeJSONObject,
Serializable {
    public String name = "";
    public String description = "";
    public String country = "";
    public String countryCode = "";
    public String floor = "";
    public String room = "";
    public String province = "";
    public String provinceCode = "";
    public String city = "";
    public String cityCode = "";
    public String district = "";
    public String districtCode = "";
    public String township = "";
    public String street = "";
    public List<z> businessAreas;
    public z boundingArea;
    public z building;
    public String houseNumber = "";
    public String postCode = "";

    public a() {
    }

    private boolean compareType(String string, String string2) {
        return !TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string) && (string2.equals(string) || string2.endsWith("." + string) || string2.endsWith("/" + string));
    }

    public a(JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        this.name = jSONObject.optString("name");
        this.description = jSONObject.optString("description");
        JSONArray jSONArray = jSONObject.optJSONArray("components");
        if (jSONArray == null || jSONArray.length() == 0) {
            jSONArray = jSONObject.optJSONArray("context");
        }
        if (jSONArray != null && jSONArray.length() > 0) {
            this.businessAreas = new ArrayList<z>();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                b b2 = new b((JSONObject)jSONArray.opt(i2));
                if (this.compareType("Province", b2.type)) {
                    this.province = b2.name;
                    if (TextUtils.isEmpty((CharSequence)b2.code)) continue;
                    this.provinceCode = b2.code;
                    continue;
                }
                if (this.compareType("City", b2.type)) {
                    this.city = b2.name;
                    if (TextUtils.isEmpty((CharSequence)b2.code)) continue;
                    this.cityCode = b2.code;
                    continue;
                }
                if (this.compareType("District", b2.type)) {
                    this.district = b2.name;
                    if (TextUtils.isEmpty((CharSequence)b2.code)) continue;
                    this.districtCode = b2.code;
                    continue;
                }
                if (this.compareType("Township", b2.type)) {
                    this.township = b2.name;
                    continue;
                }
                if (this.compareType("Road", b2.type)) {
                    this.street = b2.name;
                    continue;
                }
                if (this.compareType("HouseNumber", b2.type)) {
                    this.houseNumber = b2.name;
                    continue;
                }
                if (this.compareType("Country", b2.type)) {
                    this.country = b2.name;
                    if (TextUtils.isEmpty((CharSequence)b2.code)) continue;
                    this.countryCode = b2.code;
                    continue;
                }
                if (this.compareType("BusinessArea", b2.type)) {
                    z z2 = new z(b2.id, b2.name, b2.type, b2.category == null ? 0 : b2.category.id, b2.category == null ? "" : b2.category.name);
                    this.businessAreas.add(z2);
                    continue;
                }
                if (this.compareType("BoundingArea", b2.type)) {
                    this.boundingArea = new z(b2.id, b2.name, b2.type, b2.category == null ? 0 : b2.category.id, b2.category == null ? "" : b2.category.name);
                    continue;
                }
                if (this.compareType("Floor", b2.type)) {
                    this.floor = b2.name;
                    continue;
                }
                if (this.compareType("Room", b2.type)) {
                    this.room = b2.name;
                    continue;
                }
                if (!this.compareType("Building", b2.type)) continue;
                this.building = new z(b2.id, b2.name, b2.type, b2.category == null ? 0 : b2.category.id, b2.category == null ? "" : b2.category.name);
            }
        }
    }

    @Override
    public JSONObject makeJSONObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.putOpt("name", (Object)this.name);
            jSONObject.putOpt("description", (Object)this.description);
            List<b> list = this.makePlaces();
            if (list != null && list.size() > 0) {
                JSONArray jSONArray = new JSONArray();
                for (b b2 : list) {
                    jSONArray.put((Object)b2.makeJSONObject());
                }
                jSONObject.putOpt("context", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private List<b> makePlaces() {
        ArrayList<b> arrayList = new ArrayList<b>();
        if (!TextUtils.isEmpty((CharSequence)this.country)) {
            arrayList.add(new b("Country", this.country));
        }
        if (!TextUtils.isEmpty((CharSequence)this.province)) {
            arrayList.add(new b("Province", this.province));
        }
        if (!TextUtils.isEmpty((CharSequence)this.city)) {
            arrayList.add(new b("City", this.city));
        }
        if (!TextUtils.isEmpty((CharSequence)this.district)) {
            arrayList.add(new b("District", this.district));
        }
        if (!TextUtils.isEmpty((CharSequence)this.township)) {
            arrayList.add(new b("Township", this.township));
        }
        if (!TextUtils.isEmpty((CharSequence)this.street)) {
            arrayList.add(new b("Road", this.street));
        }
        if (!TextUtils.isEmpty((CharSequence)this.houseNumber)) {
            arrayList.add(new b("HouseNumber", this.houseNumber));
        }
        return arrayList;
    }
}

