/*
 * Decompiled with CFR 0.152.
 */
package com.wayz.location;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import android.util.Log;
import com.wayz.location.WzException;
import com.wayz.location.WzGeoFence;
import com.wayz.location.WzGeoFenceEvent;
import com.wayz.location.WzGeoFenceEventListener;
import com.wayz.location.WzGeoFenceEventType;
import com.wayz.location.WzLatLng;
import com.wayz.location.WzLocation;
import com.wayz.location.WzLocationClientOption;
import com.wayz.location.WzLocationListener;
import com.wayz.location.WzPlace;
import com.wayz.location.WzPolygonGeoFence;
import com.wayz.location.WzRoundGeoFence;
import com.wayz.location.WzSceneListener;
import com.wayz.location.WzService;
import com.wayz.location.toolkit.control.d;
import com.wayz.location.toolkit.e.b;
import com.wayz.location.toolkit.e.c;
import com.wayz.location.toolkit.e.g;
import com.wayz.location.toolkit.e.n;
import com.wayz.location.toolkit.model.Geometry;
import com.wayz.location.toolkit.model.ab;
import com.wayz.location.toolkit.model.aj;
import com.wayz.location.toolkit.model.m;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class WzLocationClient {
    private WzPlace a;
    private WzPlace b;
    private WzSceneListener c;
    private WzLocationListener d;
    private WzLocationClientOption e;
    private ServiceHandler f;
    private Messenger g;
    private boolean h = false;
    private Context i;
    private Messenger j;
    private WzLocation k;
    private volatile boolean l = false;
    private ThreadPoolExecutor m = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new ThreadPoolExecutor.DiscardPolicy());
    private WzGeoFenceEventListener n;
    private com.wayz.location.toolkit.control.g o;
    private final ServiceConnection p = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            WzLocationClient.this.g = new Messenger(iBinder);
            Message message = WzLocationClient.this.a(1, null);
            WzLocationClient.this.a(message);
            WzLocationClient.this.l = true;
        }

        public void onServiceDisconnected(ComponentName componentName) {
            WzLocationClient.this.l = false;
        }
    };

    private void a(WzLocation wzLocation) {
        if (this.e.getCoordinateType().equals("bd09")) {
            Double[] doubleArray = com.wayz.location.toolkit.e.g.gcj02ToBd09(wzLocation.getLongitude(), wzLocation.getLatitude());
            wzLocation.setLongitude(doubleArray[0]);
            wzLocation.setLatitude(doubleArray[1]);
        } else if (this.e.getCoordinateType().equals("wgs84")) {
            Double[] doubleArray = com.wayz.location.toolkit.e.g.gcj02ToWgs84(wzLocation.getLongitude(), wzLocation.getLatitude());
            wzLocation.setLongitude(doubleArray[0]);
            wzLocation.setLatitude(doubleArray[1]);
        }
    }

    public WzLocationClient(Context context) {
        this(context, Looper.myLooper());
    }

    public WzLocationClient(Context context, Looper looper) {
        if (context == null) {
            throw new IllegalStateException("\u4f20\u5165\u4e86\u7a7acontext");
        }
        try {
            this.f = new ServiceHandler(this, looper != null ? looper : Looper.myLooper());
            this.j = new Messenger((Handler)this.f);
            Intent intent = new Intent(context, WzService.class);
            context.getApplicationContext().bindService(intent, this.p, 1);
            d d2 = new d(context);
            d2.startFastLocation(context);
            this.i = context;
            this.e = new WzLocationClientOption();
            this.o = com.wayz.location.toolkit.control.g.getInstance();
            this.o.setMode(2);
            this.o.init(context);
        }
        catch (Throwable throwable) {
            Log.e((String)"WzLocationClient", (String)Log.getStackTraceString((Throwable)throwable));
        }
    }

    public WzLocationClient(Context context, WzLocationClientOption wzLocationClientOption) {
        this(context);
        if (wzLocationClientOption != null) {
            this.e = wzLocationClientOption;
        }
    }

    public WzLocationClient(Context context, WzLocationClientOption wzLocationClientOption, Looper looper) {
        this(context, looper);
        if (wzLocationClientOption != null) {
            this.e = wzLocationClientOption;
        }
    }

    public void startLocation() {
        try {
            this.h = true;
            this.a((WzLocationListener)null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void startLocation(WzLocationListener wzLocationListener) {
        try {
            this.h = true;
            this.a(wzLocationListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setSceneListener(WzSceneListener wzSceneListener) {
        this.c = wzSceneListener;
    }

    public void setLocationListener(WzLocationListener wzLocationListener) {
        this.d = wzLocationListener;
    }

    public void setLocationOption(WzLocationClientOption wzLocationClientOption) {
        this.e = wzLocationClientOption;
    }

    private void a(WzLocationListener wzLocationListener) {
        this.d = wzLocationListener;
        try {
            if (this.d != null && this.e.isFastLocation() && (this.e.isNeedPosition() || this.e.isNeedScenario() || this.e.isNeedAddress())) {
                aj aj2 = com.wayz.location.toolkit.e.c.getLastTrackResp(this.i, "com.wayz.location.appkey");
                if (aj2 == null) {
                    aj aj3 = com.wayz.location.toolkit.e.c.getLastFastWzlocation(this.i);
                    if (aj3 != null) {
                        aj3.source = "cache";
                        WzLocation wzLocation = new WzLocation(aj3);
                        this.a(wzLocation);
                        this.d.onLocationReceived(wzLocation);
                    }
                } else {
                    aj2.source = "cache";
                    WzLocation wzLocation = new WzLocation(aj2);
                    this.a(wzLocation);
                    this.d.onLocationReceived(wzLocation);
                }
            }
            this.b();
        }
        catch (Throwable throwable) {
            com.wayz.location.toolkit.e.n.e("WzLocationClient", Log.getStackTraceString((Throwable)throwable));
        }
    }

    private boolean a() {
        if (this.i == null) {
            if (this.d != null) {
                this.d.onLocationError(new WzException(1005));
            }
            return false;
        }
        return true;
    }

    private void b() {
        if (!this.a()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)com.wayz.location.toolkit.e.b.checkAppKey(this.i))) {
            Log.e((String)"WzLocationClient", (String)"ERROR: \u8bf7\u5148\u5728AndroidManifest.xml\u4e2d\u914d\u7f6eappkey\uff0c\u8be6\u7ec6\u914d\u7f6e\u65b9\u6cd5\u53c2\u8003\u5f00\u53d1\u8005\u6587\u6863\u6216sample\u9879\u76ee");
            if (this.d != null) {
                this.d.onLocationError(new WzException(1008));
            }
            throw new IllegalStateException("\u8bf7\u5148\u5728AndroidManifest.xml\u4e2d\u914d\u7f6eappkey\uff0c\u8be6\u7ec6\u914d\u7f6e\u65b9\u6cd5\u53c2\u8003\u5f00\u53d1\u8005\u6587\u6863\u6216sample\u9879\u76ee");
        }
        this.m.execute(new SendStartLocationAsync());
    }

    private Bundle c() {
        if (this.e == null) {
            this.e = new WzLocationClientOption();
        }
        return this.e.a();
    }

    public void stopLocation() {
        try {
            this.a(this.a(3, null));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onDestroy() {
        try {
            this.a(this.a(6, null));
            if (this.i != null && this.l) {
                try {
                    this.i.getApplicationContext().unbindService(this.p);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.l = false;
            }
            if (this.f != null) {
                this.f.removeCallbacksAndMessages(null);
            }
            this.o.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public WzLocation getLastKnownLocation() {
        aj aj2 = null;
        if (this.k != null) {
            this.k.a("cache");
            return this.k;
        }
        aj2 = com.wayz.location.toolkit.e.c.getLastTrackResp(this.i, "com.wayz.location.appkey");
        if (aj2 != null) {
            aj2.source = "cache";
            return new WzLocation(aj2);
        }
        return null;
    }

    private Message a(int n2, Bundle bundle) {
        Message message = Message.obtain();
        message.what = n2;
        message.replyTo = this.j;
        message.obj = bundle;
        return message;
    }

    private void a(Message message) {
        try {
            if (this.g != null) {
                this.g.send(message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getVersion() {
        return "5.3.0";
    }

    private void a(WzLocation wzLocation, WzPlace wzPlace, WzPlace wzPlace2) {
        try {
            if (this.c == null) {
                return;
            }
            if (wzPlace2 != null) {
                if (wzPlace != null) {
                    if (this.a == null) {
                        this.a = wzPlace;
                        this.c.onEnter(wzLocation, this.a, null);
                    } else if (!this.a.getName().equals(wzPlace.getName())) {
                        if (this.a.getName().length() > 0) {
                            if (this.b != null) {
                                this.c.onLeave(wzLocation, this.b);
                                this.b = null;
                            }
                            this.c.onLeave(wzLocation, this.a);
                        }
                        this.a = wzPlace;
                        this.c.onEnter(wzLocation, this.a, null);
                    }
                    if (this.b != null) {
                        if (!wzPlace2.getName().equals(this.b.getName())) {
                            this.c.onLeave(wzLocation, this.b);
                            this.b = wzPlace2;
                            this.c.onEnter(wzLocation, this.a, this.b);
                        }
                    } else {
                        this.b = wzPlace2;
                        this.c.onEnter(wzLocation, this.a, this.b);
                    }
                }
            } else if (wzPlace != null) {
                if (this.a != null) {
                    if (!wzPlace.getName().equals(this.a.getName())) {
                        if (this.b != null) {
                            this.c.onLeave(wzLocation, this.b);
                            this.b = null;
                        }
                        this.c.onLeave(wzLocation, this.a);
                        this.a = wzPlace;
                        this.c.onEnter(wzLocation, this.a, this.b);
                    } else if (this.b != null) {
                        this.c.onLeave(wzLocation, this.b);
                        this.b = null;
                    }
                } else {
                    this.a = wzPlace;
                    this.c.onEnter(wzLocation, this.a, this.b);
                }
            } else {
                if (this.b != null) {
                    this.c.onLeave(wzLocation, this.b);
                    this.b = null;
                }
                if (this.a != null) {
                    this.c.onLeave(wzLocation, this.a);
                    this.a = null;
                }
            }
        }
        catch (Exception exception) {
            com.wayz.location.toolkit.e.n.e("WzException", Log.getStackTraceString((Throwable)exception));
        }
    }

    public void setGeoFenceEventListener(WzGeoFenceEventListener wzGeoFenceEventListener) {
        this.n = wzGeoFenceEventListener;
    }

    private void d() {
        int n2 = 20;
        while (!this.l && n2 > 0) {
            --n2;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addPolygonGeoFence(WzPolygonGeoFence wzPolygonGeoFence) {
        if (!this.a()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)com.wayz.location.toolkit.e.b.checkAppKey(this.i))) {
            Log.e((String)"WzLocationClient", (String)"ERROR: \u8bf7\u5148\u5728AndroidManifest.xml\u4e2d\u914d\u7f6eappkey\uff0c\u8be6\u7ec6\u914d\u7f6e\u65b9\u6cd5\u53c2\u8003\u5f00\u53d1\u8005\u6587\u6863\u6216sample\u9879\u76ee");
            if (this.n != null) {
                WzGeoFenceEvent wzGeoFenceEvent = new WzGeoFenceEvent("\u8bf7\u5148\u5728AndroidManifest.xml\u4e2d\u914d\u7f6eappkey\uff0c\u8be6\u7ec6\u914d\u7f6e\u65b9\u6cd5\u53c2\u8003\u5f00\u53d1\u8005\u6587\u6863\u6216sample\u9879\u76ee", WzGeoFenceEventType.CREATE_ERR);
                this.n.onGeoFenceEventReceived(Arrays.asList(wzGeoFenceEvent));
                throw new IllegalStateException("\u8bf7\u5148\u5728AndroidManifest.xml\u4e2d\u914d\u7f6eappkey\uff0c\u8be6\u7ec6\u914d\u7f6e\u65b9\u6cd5\u53c2\u8003\u5f00\u53d1\u8005\u6587\u6863\u6216sample\u9879\u76ee");
            }
            return;
        }
        List<WzLatLng> list = wzPolygonGeoFence.getLatLngList();
        if (list == null || list.size() < 3) {
            if (this.n != null) {
                WzGeoFenceEvent wzGeoFenceEvent = new WzGeoFenceEvent("\u521b\u5efa\u591a\u8fb9\u5f62\u56f4\u680f\u81f3\u5c11\u67093\u4e2a\u70b9", WzGeoFenceEventType.CREATE_ERR);
                this.n.onGeoFenceEventReceived(Arrays.asList(wzGeoFenceEvent));
            }
            Log.e((String)"WzLocationClient", (String)"ERROR: \u521b\u5efa\u591a\u8fb9\u5f62\u56f4\u680f\u81f3\u5c11\u67093\u4e2a\u70b9");
            return;
        }
        Message message = this.a(14, wzPolygonGeoFence.getBundle());
        this.m.execute(new SendMessageAsync(message));
    }

    public void addRoundGeoFence(WzRoundGeoFence wzRoundGeoFence) {
        if (!this.a()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)com.wayz.location.toolkit.e.b.checkAppKey(this.i))) {
            if (this.n != null) {
                WzGeoFenceEvent wzGeoFenceEvent = new WzGeoFenceEvent("\u8bf7\u5148\u5728AndroidManifest.xml\u4e2d\u914d\u7f6eappkey\uff0c\u8be6\u7ec6\u914d\u7f6e\u65b9\u6cd5\u53c2\u8003\u5f00\u53d1\u8005\u6587\u6863\u6216sample\u9879\u76ee", WzGeoFenceEventType.CREATE_ERR);
                this.n.onGeoFenceEventReceived(Arrays.asList(wzGeoFenceEvent));
            }
            return;
        }
        int n2 = wzRoundGeoFence.geoFence.pointRadius;
        if (n2 == 0) {
            if (this.n != null) {
                WzGeoFenceEvent wzGeoFenceEvent = new WzGeoFenceEvent("\u521b\u5efa\u5706\u5f62\u56f4\u680f\u534a\u5f84\u5927\u4e8e0", WzGeoFenceEventType.CREATE_ERR);
                this.n.onGeoFenceEventReceived(Arrays.asList(wzGeoFenceEvent));
            }
            return;
        }
        Message message = this.a(14, wzRoundGeoFence.getBundle());
        this.m.execute(new SendMessageAsync(message));
    }

    public void deleteGeoFence(String string) {
        if (!this.a()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)com.wayz.location.toolkit.e.b.checkAppKey(this.i))) {
            if (this.n != null) {
                WzGeoFenceEvent wzGeoFenceEvent = new WzGeoFenceEvent("\u8bf7\u5148\u5728AndroidManifest.xml\u4e2d\u914d\u7f6eappkey\uff0c\u8be6\u7ec6\u914d\u7f6e\u65b9\u6cd5\u53c2\u8003\u5f00\u53d1\u8005\u6587\u6863\u6216sample\u9879\u76ee", WzGeoFenceEventType.CREATE_ERR);
                this.n.onGeoFenceEventReceived(Arrays.asList(wzGeoFenceEvent));
            }
            return;
        }
        com.wayz.location.toolkit.control.g.getInstance().deleteFence(string);
    }

    public List<WzGeoFence> getAllGeoFence() {
        if (!this.a()) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)com.wayz.location.toolkit.e.b.checkAppKey(this.i))) {
            if (this.n != null) {
                WzGeoFenceEvent wzGeoFenceEvent = new WzGeoFenceEvent("\u8bf7\u5148\u5728AndroidManifest.xml\u4e2d\u914d\u7f6eappkey\uff0c\u8be6\u7ec6\u914d\u7f6e\u65b9\u6cd5\u53c2\u8003\u5f00\u53d1\u8005\u6587\u6863\u6216sample\u9879\u76ee", WzGeoFenceEventType.CREATE_ERR);
                this.n.onGeoFenceEventReceived(Arrays.asList(wzGeoFenceEvent));
            }
            return null;
        }
        List<m> list = this.o.getAllFence();
        ArrayList<WzGeoFence> arrayList = new ArrayList<WzGeoFence>();
        for (m m2 : list) {
            if (m2.geometries == null || m2.geometries.size() <= 0) continue;
            Geometry geometry = m2.geometries.get(0);
            if (geometry instanceof ab) {
                arrayList.add(new WzRoundGeoFence(m2));
                continue;
            }
            arrayList.add(new WzPolygonGeoFence(m2));
        }
        return arrayList;
    }

    private static final class ServiceHandler
    extends Handler {
        WeakReference<WzLocationClient> client;

        ServiceHandler(WzLocationClient wzLocationClient, Looper looper) {
            super(looper);
            this.client = new WeakReference<WzLocationClient>(wzLocationClient);
        }

        public void handleMessage(Message message) {
            try {
                if (this.client == null) {
                    return;
                }
                if (this.client.get() == null) {
                    return;
                }
                if (!(message.obj instanceof Bundle)) {
                    return;
                }
                Bundle bundle = (Bundle)message.obj;
                switch (message.what) {
                    case 4: {
                        WzLocation wzLocation = new WzLocation(bundle);
                        if (((WzLocationClient)this.client.get()).d != null) {
                            ((WzLocationClient)this.client.get()).k = wzLocation;
                            ((WzLocationClient)this.client.get()).a(wzLocation);
                            ((WzLocationClient)this.client.get()).d.onLocationReceived(wzLocation);
                        }
                        if (((WzLocationClient)this.client.get()).c == null) break;
                        ((WzLocationClient)this.client.get()).a(wzLocation, wzLocation.getMainScene(), wzLocation.getSubScene());
                        break;
                    }
                    case 5: {
                        int n2 = bundle.getInt("BUNDLE_ERROR");
                        if (n2 == 404) {
                            ((WzLocationClient)this.client.get()).d.onLocationError(new WzException(1010));
                            break;
                        }
                        ((WzLocationClient)this.client.get()).d.onLocationError(new WzException(n2));
                        break;
                    }
                    case 15: {
                        if (((WzLocationClient)this.client.get()).n == null) break;
                        String string = bundle.getString("BUNDLE_ADDFENCE_FENCEID");
                        WzGeoFenceEvent wzGeoFenceEvent = new WzGeoFenceEvent();
                        wzGeoFenceEvent.a(WzGeoFenceEventType.CREATED);
                        wzGeoFenceEvent.a(string);
                        ((WzLocationClient)this.client.get()).n.onGeoFenceEventReceived(Arrays.asList(wzGeoFenceEvent));
                        break;
                    }
                    case 16: {
                        String string = bundle.getString("ERROR");
                        if (((WzLocationClient)this.client.get()).n == null) break;
                        WzGeoFenceEvent wzGeoFenceEvent = new WzGeoFenceEvent();
                        wzGeoFenceEvent.a(WzGeoFenceEventType.CREATE_ERR);
                        wzGeoFenceEvent.b(string);
                        ((WzLocationClient)this.client.get()).n.onGeoFenceEventReceived(Arrays.asList(wzGeoFenceEvent));
                        break;
                    }
                    case 17: {
                        if (((WzLocationClient)this.client.get()).n == null || ((WzLocationClient)this.client.get()).e.getServiceMode() != 2) break;
                        List<WzGeoFenceEvent> list = WzGeoFenceEvent.a(bundle);
                        ((WzLocationClient)this.client.get()).n.onGeoFenceEventReceived(list);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                com.wayz.location.toolkit.e.n.e("WzException", "WzLocationClient:" + Log.getStackTraceString((Throwable)exception));
            }
        }
    }

    private final class SendStartLocationAsync
    implements Runnable {
        SendStartLocationAsync() {
        }

        @Override
        public void run() {
            WzLocationClient.this.d();
            WzLocationClient.this.a(WzLocationClient.this.a(7, WzLocationClient.this.c()));
            WzLocationClient.this.a(WzLocationClient.this.a(2, null));
        }
    }

    private final class SendMessageAsync
    implements Runnable {
        private Message message;

        SendMessageAsync(Message message) {
            this.message = message;
        }

        @Override
        public void run() {
            WzLocationClient.this.d();
            WzLocationClient.this.a(this.message);
        }
    }
}

