/*
 * Decompiled with CFR 0.152.
 */
package com.wayz.location.toolkit.model;

import android.location.Location;
import android.os.Build;
import android.text.TextUtils;
import com.wayz.location.toolkit.e.d;
import com.wayz.location.toolkit.e.m;
import com.wayz.location.toolkit.model.MakeJSONObject;
import com.wayz.location.toolkit.model.a;
import com.wayz.location.toolkit.model.ac;
import com.wayz.location.toolkit.model.am;
import com.wayz.location.toolkit.model.e;
import com.wayz.location.toolkit.model.g;
import com.wayz.location.toolkit.model.h;
import com.wayz.location.toolkit.model.i;
import com.wayz.location.toolkit.model.p;
import com.wayz.location.toolkit.wifi.WifiNetwork;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;

public class t
implements MakeJSONObject {
    public String locationId = "";
    private long timeStamp = System.currentTimeMillis();
    public p gnss;
    public List<g> cellObservations;
    public List<am> wifiObservations;
    public List<e> blueToothObservations;
    public i connection;
    public a address;
    public List<ac> estimates;
    public ac passive;
    public ac position;

    public t() {
    }

    public t(Location location, Vector<WifiNetwork> vector, List<h> list, int n2, String string, boolean bl) {
        int n3;
        if (location != null) {
            this.gnss = new p();
            if (Build.VERSION.SDK_INT >= 18) {
                this.gnss.mock = location.isFromMockProvider();
            }
            this.gnss.accuracy = location.getAccuracy();
            this.gnss.heading = (int)location.getBearing();
            this.gnss.lngLat.altitude = location.getAltitude();
            this.gnss.lngLat.latitude = location.getLatitude();
            this.gnss.lngLat.longitude = location.getLongitude();
            this.gnss.valid = true;
            this.gnss.timestamp = location.getTime();
            this.gnss.velocity = location.getSpeed();
        }
        if (vector != null && vector.size() > 0) {
            this.wifiObservations = new ArrayList<am>();
            Collections.sort(vector, d.COMPARATOR);
            n3 = 0;
            boolean bl2 = false;
            boolean bl3 = !TextUtils.isEmpty((CharSequence)string);
            for (WifiNetwork wifiNetwork : vector) {
                ++n3;
                am am2 = new am();
                am2.signalStrength = Math.abs(wifiNetwork.getSignalStrength());
                am2.freq = wifiNetwork.getFrequency();
                am2.timeStamp = wifiNetwork.getTimestamp();
                am2.macAddress = wifiNetwork.getMACAddress();
                am2.ssid = wifiNetwork.getSSID();
                if (am2.macAddress != null && bl3 && am2.macAddress.equals(string)) {
                    am2.isConnected = true;
                    bl2 = true;
                }
                if (n3 <= n2) {
                    this.wifiObservations.add(am2);
                    continue;
                }
                if (!bl3 || bl2) break;
                if (!am2.isConnected) continue;
                this.wifiObservations.add(am2);
            }
        }
        if (list != null && list.size() > 0) {
            this.cellObservations = new ArrayList<g>();
            for (n3 = 0; n3 < list.size(); ++n3) {
                g g2 = new g();
                if (n3 == 0) {
                    g2.connected = true;
                }
                g2.cid = list.get((int)n3).cid;
                g2.lac = list.get((int)n3).lac;
                g2.mcc = list.get((int)n3).mcc;
                g2.mnc = list.get((int)n3).mnc;
                g2.signalStrength = Math.abs(list.get((int)n3).signalStrength);
                g2.radioType = list.get((int)n3).radioType;
                g2.timeStamp = System.currentTimeMillis();
                this.cellObservations.add(g2);
            }
        }
        this.locationId = UUID.randomUUID().toString();
    }

    public t(List<e> list) {
        this.blueToothObservations = list;
        this.locationId = UUID.randomUUID().toString();
    }

    public String toJsonString() {
        return this.makeJSONObject().toString();
    }

    @Override
    public JSONObject makeJSONObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.putOpt("timestamp", (Object)this.timeStamp);
            jSONObject.putOpt("gnss", (Object)m.getJSONObjectFromMakeJSONObjectOrNull(this.gnss));
            jSONObject.putOpt("address", (Object)m.getJSONObjectFromMakeJSONObjectOrNull(this.address));
            jSONObject.putOpt("cellulars", (Object)m.getJSONArrayFromMakeJSONObjectOrNull(this.cellObservations));
            jSONObject.putOpt("wifis", (Object)m.getJSONArrayFromMakeJSONObjectOrNull(this.wifiObservations));
            jSONObject.putOpt("connection", (Object)m.getJSONObjectFromMakeJSONObjectOrNull(this.connection));
            jSONObject.putOpt("bluetooths", (Object)m.getJSONArrayFromMakeJSONObjectOrNull(this.blueToothObservations));
            jSONObject.putOpt("position", (Object)m.getJSONObjectFromMakeJSONObjectOrNull(this.position));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }
}

