/*
 * Decompiled with CFR 0.152.
 */
package com.wayz.location.toolkit.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.text.TextUtils;
import com.wayz.location.toolkit.e.n;
import com.wayz.location.toolkit.e.y;
import com.wayz.location.toolkit.model.e;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressLint(value={"MissingPermission", "NewApi"})
public class BlueToothManager
extends ScanCallback
implements BluetoothAdapter.LeScanCallback {
    private Context a;
    private BluetoothAdapter b;
    private List<e> c = new ArrayList<e>();
    private Map<String, e> d = new HashMap<String, e>();
    private boolean e = false;
    private BluetoothLeScanner f;
    private boolean g = false;
    private BroadcastReceiver h = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent == null || intent.getAction() == null) {
                return;
            }
            if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction())) {
                int n2 = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
                switch (n2) {
                    case 12: {
                        BlueToothManager.this.startLeScan();
                        break;
                    }
                    case 10: {
                        BlueToothManager.this.g = false;
                    }
                }
            }
        }
    };

    public List<e> getBlueToothDevices() {
        return this.c;
    }

    public Map<String, e> getSmoothMap() {
        return this.d;
    }

    public BlueToothManager(Context context) {
        if (context != null) {
            this.a = context.getApplicationContext();
        }
        if (this.c == null) {
            this.c = new ArrayList<e>();
        }
        n.e("CONTROL_SERVICE", "[\u84dd\u7259]init");
    }

    public void registerBlueTooth() {
        BluetoothManager bluetoothManager;
        if (Build.VERSION.SDK_INT >= 18) {
            bluetoothManager = (BluetoothManager)this.a.getSystemService("bluetooth");
            if (bluetoothManager != null) {
                this.b = bluetoothManager.getAdapter();
            }
        } else {
            this.b = BluetoothAdapter.getDefaultAdapter();
        }
        this.e = this.b != null;
        bluetoothManager = new IntentFilter();
        bluetoothManager.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        try {
            this.a.registerReceiver(this.h, (IntentFilter)bluetoothManager);
        }
        catch (Exception exception) {
            // empty catch block
        }
        n.e("CONTROL_SERVICE", "[\u84dd\u7259]register");
    }

    public void unRegister() {
        if (!this.e) {
            return;
        }
        this.a.unregisterReceiver(this.h);
        this.stopLeScan();
        n.e("CONTROL_SERVICE", "[\u84dd\u7259]\u56de\u6536");
    }

    public boolean isScanning() {
        return this.e && this.g;
    }

    public void startLeScan() {
        if (!this.blueToothUsableCheck()) {
            return;
        }
        if (this.isScanning()) {
            return;
        }
        if (this.b == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.f = this.b.getBluetoothLeScanner();
            if (this.f == null) {
                return;
            }
            ArrayList<ScanFilter> arrayList = new ArrayList<ScanFilter>();
            ScanFilter.Builder builder = new ScanFilter.Builder();
            String[] stringArray = "".split(",");
            if (stringArray != null) {
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2 && !TextUtils.isEmpty((CharSequence)stringArray[i2]); ++i2) {
                    arrayList.add(builder.setDeviceAddress(stringArray[i2]).build());
                }
            }
            ScanSettings.Builder builder2 = new ScanSettings.Builder().setScanMode(2);
            if (Build.VERSION.SDK_INT >= 26) {
                builder2.setPhy(255).setLegacy(false);
            }
            ScanSettings scanSettings = builder2.build();
            this.f.startScan(arrayList, scanSettings, (ScanCallback)this);
        } else if (Build.VERSION.SDK_INT >= 18) {
            this.b.startLeScan((BluetoothAdapter.LeScanCallback)this);
        }
        this.g = true;
        n.e("CONTROL_SERVICE", "[\u84dd\u7259]\u5f00\u59cb\u626b\u63cf\u84dd\u7259\uff1a");
    }

    public void stopLeScan() {
        if (!this.blueToothUsableCheck()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.f != null) {
                this.f.stopScan((ScanCallback)this);
            }
        } else if (Build.VERSION.SDK_INT >= 18 && this.b != null) {
            this.b.stopLeScan((BluetoothAdapter.LeScanCallback)this);
        }
        this.g = false;
        this.c.clear();
        n.e("CONTROL_SERVICE", "[\u84dd\u7259]\u505c\u6b62\u626b\u63cf\u84dd\u7259");
    }

    private void a(BluetoothDevice bluetoothDevice, int n2) {
        if (bluetoothDevice == null) {
            return;
        }
        String string = bluetoothDevice.getName();
        if (2 == bluetoothDevice.getType() && !TextUtils.isEmpty((CharSequence)string)) {
            String string2 = bluetoothDevice.getAddress();
            e e2 = this.d.get(string2);
            e e3 = new e();
            e3.name = string;
            e3.macAddress = string2;
            e3.timeStamp = System.currentTimeMillis();
            e3.signalStrength = e2 == null ? y.getSmoothRssi(n2, e3.timeStamp, null) : y.getSmoothRssi(n2, e3.timeStamp, e2);
            this.d.put(string2, e3);
        }
    }

    public void onLeScan(BluetoothDevice bluetoothDevice, int n2, byte[] byArray) {
        this.a(bluetoothDevice, n2);
    }

    public void onScanResult(int n2, ScanResult scanResult) {
        super.onScanResult(n2, scanResult);
        if (scanResult == null) {
            return;
        }
        this.a(scanResult.getDevice(), scanResult.getRssi());
    }

    public void onScanFailed(int n2) {
        super.onScanFailed(n2);
        n.e("CONTROL_SERVICE", "onScanFailed" + n2);
    }

    public void onBatchScanResults(List<ScanResult> list) {
        n.e("CONTROL_SERVICE", "onBatchScanResults");
    }

    public boolean blueToothUsableCheck() {
        try {
            return this.e && this.b.isEnabled();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

